/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.yetus.audience.InterfaceAudience;

public abstract class LogicalTypeAnnotation {
    @InterfaceAudience.Private
    public abstract OriginalType toOriginalType();

    public abstract <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> var1);

    abstract LogicalTypeToken getType();

    String typeParametersAsString() {
        return "";
    }

    boolean isValidColumnOrder(ColumnOrder columnOrder) {
        return columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.UNDEFINED || columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getType());
        sb.append(this.typeParametersAsString());
        return sb.toString();
    }

    PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
        throw new UnsupportedOperationException("Stringifier is not supported for the logical type: " + this);
    }

    @InterfaceAudience.Private
    public static LogicalTypeAnnotation fromOriginalType(OriginalType originalType, DecimalMetadata decimalMetadata) {
        if (originalType == null) {
            return null;
        }
        switch (originalType) {
            case UTF8: {
                return LogicalTypeAnnotation.stringType();
            }
            case MAP: {
                return LogicalTypeAnnotation.mapType();
            }
            case DECIMAL: {
                int scale = decimalMetadata == null ? 0 : decimalMetadata.getScale();
                int precision = decimalMetadata == null ? 0 : decimalMetadata.getPrecision();
                return LogicalTypeAnnotation.decimalType(scale, precision);
            }
            case LIST: {
                return LogicalTypeAnnotation.listType();
            }
            case DATE: {
                return LogicalTypeAnnotation.dateType();
            }
            case INTERVAL: {
                return IntervalLogicalTypeAnnotation.getInstance();
            }
            case TIMESTAMP_MILLIS: {
                return LogicalTypeAnnotation.timestampType(true, TimeUnit.MILLIS);
            }
            case TIMESTAMP_MICROS: {
                return LogicalTypeAnnotation.timestampType(true, TimeUnit.MICROS);
            }
            case TIME_MILLIS: {
                return LogicalTypeAnnotation.timeType(true, TimeUnit.MILLIS);
            }
            case TIME_MICROS: {
                return LogicalTypeAnnotation.timeType(true, TimeUnit.MICROS);
            }
            case UINT_8: {
                return LogicalTypeAnnotation.intType(8, false);
            }
            case UINT_16: {
                return LogicalTypeAnnotation.intType(16, false);
            }
            case UINT_32: {
                return LogicalTypeAnnotation.intType(32, false);
            }
            case UINT_64: {
                return LogicalTypeAnnotation.intType(64, false);
            }
            case INT_8: {
                return LogicalTypeAnnotation.intType(8, true);
            }
            case INT_16: {
                return LogicalTypeAnnotation.intType(16, true);
            }
            case INT_32: {
                return LogicalTypeAnnotation.intType(32, true);
            }
            case INT_64: {
                return LogicalTypeAnnotation.intType(64, true);
            }
            case ENUM: {
                return LogicalTypeAnnotation.enumType();
            }
            case JSON: {
                return LogicalTypeAnnotation.jsonType();
            }
            case BSON: {
                return LogicalTypeAnnotation.bsonType();
            }
            case MAP_KEY_VALUE: {
                return MapKeyValueTypeAnnotation.getInstance();
            }
        }
        throw new RuntimeException("Can't convert original type to logical type, unknown original type " + (Object)((Object)originalType));
    }

    public static StringLogicalTypeAnnotation stringType() {
        return StringLogicalTypeAnnotation.INSTANCE;
    }

    public static MapLogicalTypeAnnotation mapType() {
        return MapLogicalTypeAnnotation.INSTANCE;
    }

    public static ListLogicalTypeAnnotation listType() {
        return ListLogicalTypeAnnotation.INSTANCE;
    }

    public static EnumLogicalTypeAnnotation enumType() {
        return EnumLogicalTypeAnnotation.INSTANCE;
    }

    public static DecimalLogicalTypeAnnotation decimalType(int scale, int precision) {
        return new DecimalLogicalTypeAnnotation(scale, precision);
    }

    public static DateLogicalTypeAnnotation dateType() {
        return DateLogicalTypeAnnotation.INSTANCE;
    }

    public static TimeLogicalTypeAnnotation timeType(boolean isAdjustedToUTC, TimeUnit unit) {
        return new TimeLogicalTypeAnnotation(isAdjustedToUTC, unit);
    }

    public static TimestampLogicalTypeAnnotation timestampType(boolean isAdjustedToUTC, TimeUnit unit) {
        return new TimestampLogicalTypeAnnotation(isAdjustedToUTC, unit);
    }

    public static IntLogicalTypeAnnotation intType(int bitWidth, boolean isSigned) {
        Preconditions.checkArgument(bitWidth == 8 || bitWidth == 16 || bitWidth == 32 || bitWidth == 64, "Invalid bit width for integer logical type, " + bitWidth + " is not allowed, valid bit width values: 8, 16, 32, 64");
        return new IntLogicalTypeAnnotation(bitWidth, isSigned);
    }

    public static JsonLogicalTypeAnnotation jsonType() {
        return JsonLogicalTypeAnnotation.INSTANCE;
    }

    public static BsonLogicalTypeAnnotation bsonType() {
        return BsonLogicalTypeAnnotation.INSTANCE;
    }

    public static UUIDLogicalTypeAnnotation uuidType() {
        return UUIDLogicalTypeAnnotation.INSTANCE;
    }

    public static interface LogicalTypeAnnotationVisitor<T> {
        default public Optional<T> visit(StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(MapLogicalTypeAnnotation mapLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(ListLogicalTypeAnnotation listLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(EnumLogicalTypeAnnotation enumLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(DecimalLogicalTypeAnnotation decimalLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(TimeLogicalTypeAnnotation timeLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(TimestampLogicalTypeAnnotation timestampLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(IntLogicalTypeAnnotation intLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(BsonLogicalTypeAnnotation bsonLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(IntervalLogicalTypeAnnotation intervalLogicalType) {
            return Optional.empty();
        }

        default public Optional<T> visit(MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
            return Optional.empty();
        }
    }

    public static class MapKeyValueTypeAnnotation
    extends LogicalTypeAnnotation {
        private static MapKeyValueTypeAnnotation INSTANCE = new MapKeyValueTypeAnnotation();

        public static MapKeyValueTypeAnnotation getInstance() {
            return INSTANCE;
        }

        private MapKeyValueTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.MAP_KEY_VALUE;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.MAP_KEY_VALUE;
        }

        public boolean equals(Object obj) {
            return obj instanceof MapKeyValueTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class IntervalLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static IntervalLogicalTypeAnnotation INSTANCE = new IntervalLogicalTypeAnnotation();

        public static LogicalTypeAnnotation getInstance() {
            return INSTANCE;
        }

        private IntervalLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.INTERVAL;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.INTERVAL;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntervalLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.INTERVAL_STRINGIFIER;
        }

        @Override
        boolean isValidColumnOrder(ColumnOrder columnOrder) {
            return columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.UNDEFINED;
        }
    }

    public static class UUIDLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final UUIDLogicalTypeAnnotation INSTANCE = new UUIDLogicalTypeAnnotation();
        public static final int BYTES = 16;

        private UUIDLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return null;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.UUID;
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.UUID_STRINGIFIER;
        }
    }

    public static class BsonLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final BsonLogicalTypeAnnotation INSTANCE = new BsonLogicalTypeAnnotation();

        private BsonLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.BSON;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.BSON;
        }

        public boolean equals(Object obj) {
            return obj instanceof BsonLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.DEFAULT_STRINGIFIER;
        }
    }

    public static class JsonLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final JsonLogicalTypeAnnotation INSTANCE = new JsonLogicalTypeAnnotation();

        private JsonLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.JSON;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.JSON;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsonLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.UTF8_STRINGIFIER;
        }
    }

    public static class IntLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final Set<Integer> VALID_BIT_WIDTH = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(8, 16, 32, 64)));
        private final int bitWidth;
        private final boolean isSigned;

        private IntLogicalTypeAnnotation(int bitWidth, boolean isSigned) {
            if (!VALID_BIT_WIDTH.contains(bitWidth)) {
                throw new IllegalArgumentException("Invalid integer bit width: " + bitWidth);
            }
            this.bitWidth = bitWidth;
            this.isSigned = isSigned;
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            switch (this.bitWidth) {
                case 8: {
                    return this.isSigned ? OriginalType.INT_8 : OriginalType.UINT_8;
                }
                case 16: {
                    return this.isSigned ? OriginalType.INT_16 : OriginalType.UINT_16;
                }
                case 32: {
                    return this.isSigned ? OriginalType.INT_32 : OriginalType.UINT_32;
                }
                case 64: {
                    return this.isSigned ? OriginalType.INT_64 : OriginalType.UINT_64;
                }
            }
            return null;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.INTEGER;
        }

        @Override
        protected String typeParametersAsString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.bitWidth);
            sb.append(",");
            sb.append(this.isSigned);
            sb.append(")");
            return sb.toString();
        }

        public int getBitWidth() {
            return this.bitWidth;
        }

        public boolean isSigned() {
            return this.isSigned;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IntLogicalTypeAnnotation)) {
                return false;
            }
            IntLogicalTypeAnnotation other = (IntLogicalTypeAnnotation)obj;
            return this.bitWidth == other.bitWidth && this.isSigned == other.isSigned;
        }

        public int hashCode() {
            return Objects.hash(this.bitWidth, this.isSigned);
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return this.isSigned ? PrimitiveStringifier.DEFAULT_STRINGIFIER : PrimitiveStringifier.UNSIGNED_STRINGIFIER;
        }
    }

    public static class TimestampLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private final boolean isAdjustedToUTC;
        private final TimeUnit unit;

        private TimestampLogicalTypeAnnotation(boolean isAdjustedToUTC, TimeUnit unit) {
            this.isAdjustedToUTC = isAdjustedToUTC;
            this.unit = unit;
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            switch (this.unit) {
                case MILLIS: {
                    return OriginalType.TIMESTAMP_MILLIS;
                }
                case MICROS: {
                    return OriginalType.TIMESTAMP_MICROS;
                }
            }
            return null;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.TIMESTAMP;
        }

        @Override
        protected String typeParametersAsString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append((Object)this.unit);
            sb.append(",");
            sb.append(this.isAdjustedToUTC);
            sb.append(")");
            return sb.toString();
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public boolean isAdjustedToUTC() {
            return this.isAdjustedToUTC;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimestampLogicalTypeAnnotation)) {
                return false;
            }
            TimestampLogicalTypeAnnotation other = (TimestampLogicalTypeAnnotation)obj;
            return this.isAdjustedToUTC == other.isAdjustedToUTC && this.unit == other.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.isAdjustedToUTC, this.unit});
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            switch (this.unit) {
                case MICROS: {
                    return this.isAdjustedToUTC ? PrimitiveStringifier.TIMESTAMP_MICROS_UTC_STRINGIFIER : PrimitiveStringifier.TIMESTAMP_MICROS_STRINGIFIER;
                }
                case MILLIS: {
                    return this.isAdjustedToUTC ? PrimitiveStringifier.TIMESTAMP_MILLIS_UTC_STRINGIFIER : PrimitiveStringifier.TIMESTAMP_MILLIS_STRINGIFIER;
                }
                case NANOS: {
                    return this.isAdjustedToUTC ? PrimitiveStringifier.TIMESTAMP_NANOS_UTC_STRINGIFIER : PrimitiveStringifier.TIMESTAMP_NANOS_STRINGIFIER;
                }
            }
            return super.valueStringifier(primitiveType);
        }
    }

    public static class TimeLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private final boolean isAdjustedToUTC;
        private final TimeUnit unit;

        private TimeLogicalTypeAnnotation(boolean isAdjustedToUTC, TimeUnit unit) {
            this.isAdjustedToUTC = isAdjustedToUTC;
            this.unit = unit;
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            switch (this.unit) {
                case MILLIS: {
                    return OriginalType.TIME_MILLIS;
                }
                case MICROS: {
                    return OriginalType.TIME_MICROS;
                }
            }
            return null;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.TIME;
        }

        @Override
        protected String typeParametersAsString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append((Object)this.unit);
            sb.append(",");
            sb.append(this.isAdjustedToUTC);
            sb.append(")");
            return sb.toString();
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public boolean isAdjustedToUTC() {
            return this.isAdjustedToUTC;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimeLogicalTypeAnnotation)) {
                return false;
            }
            TimeLogicalTypeAnnotation other = (TimeLogicalTypeAnnotation)obj;
            return this.isAdjustedToUTC == other.isAdjustedToUTC && this.unit == other.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.isAdjustedToUTC, this.unit});
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            switch (this.unit) {
                case MILLIS: 
                case MICROS: {
                    return this.isAdjustedToUTC ? PrimitiveStringifier.TIME_UTC_STRINGIFIER : PrimitiveStringifier.TIME_STRINGIFIER;
                }
                case NANOS: {
                    return this.isAdjustedToUTC ? PrimitiveStringifier.TIME_NANOS_UTC_STRINGIFIER : PrimitiveStringifier.TIME_NANOS_STRINGIFIER;
                }
            }
            return super.valueStringifier(primitiveType);
        }
    }

    public static enum TimeUnit {
        MILLIS,
        MICROS,
        NANOS;

    }

    public static class DateLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final DateLogicalTypeAnnotation INSTANCE = new DateLogicalTypeAnnotation();

        private DateLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.DATE;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.DATE;
        }

        public boolean equals(Object obj) {
            return obj instanceof DateLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.DATE_STRINGIFIER;
        }
    }

    public static class DecimalLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private final PrimitiveStringifier stringifier;
        private final int scale;
        private final int precision;

        private DecimalLogicalTypeAnnotation(int scale, int precision) {
            this.scale = scale;
            this.precision = precision;
            this.stringifier = PrimitiveStringifier.createDecimalStringifier(scale);
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.DECIMAL;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.DECIMAL;
        }

        @Override
        protected String typeParametersAsString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.precision);
            sb.append(",");
            sb.append(this.scale);
            sb.append(")");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DecimalLogicalTypeAnnotation)) {
                return false;
            }
            DecimalLogicalTypeAnnotation other = (DecimalLogicalTypeAnnotation)obj;
            return this.scale == other.scale && this.precision == other.precision;
        }

        public int hashCode() {
            return Objects.hash(this.scale, this.precision);
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return this.stringifier;
        }
    }

    public static class EnumLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final EnumLogicalTypeAnnotation INSTANCE = new EnumLogicalTypeAnnotation();

        private EnumLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.ENUM;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.ENUM;
        }

        public boolean equals(Object obj) {
            return obj instanceof EnumLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.UTF8_STRINGIFIER;
        }
    }

    public static class ListLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final ListLogicalTypeAnnotation INSTANCE = new ListLogicalTypeAnnotation();

        private ListLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.LIST;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.LIST;
        }

        public boolean equals(Object obj) {
            return obj instanceof ListLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class MapLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final MapLogicalTypeAnnotation INSTANCE = new MapLogicalTypeAnnotation();

        private MapLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.MAP;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.MAP;
        }

        public boolean equals(Object obj) {
            return obj instanceof MapLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class StringLogicalTypeAnnotation
    extends LogicalTypeAnnotation {
        private static final StringLogicalTypeAnnotation INSTANCE = new StringLogicalTypeAnnotation();

        private StringLogicalTypeAnnotation() {
        }

        @Override
        @InterfaceAudience.Private
        public OriginalType toOriginalType() {
            return OriginalType.UTF8;
        }

        @Override
        public <T> Optional<T> accept(LogicalTypeAnnotationVisitor<T> logicalTypeAnnotationVisitor) {
            return logicalTypeAnnotationVisitor.visit(this);
        }

        @Override
        LogicalTypeToken getType() {
            return LogicalTypeToken.STRING;
        }

        public boolean equals(Object obj) {
            return obj instanceof StringLogicalTypeAnnotation;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        PrimitiveStringifier valueStringifier(PrimitiveType primitiveType) {
            return PrimitiveStringifier.UTF8_STRINGIFIER;
        }
    }

    static enum LogicalTypeToken {
        MAP{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.mapType();
            }
        }
        ,
        LIST{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.listType();
            }
        }
        ,
        STRING{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.stringType();
            }
        }
        ,
        MAP_KEY_VALUE{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return MapKeyValueTypeAnnotation.getInstance();
            }
        }
        ,
        ENUM{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.enumType();
            }
        }
        ,
        DECIMAL{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                if (params.size() != 2) {
                    throw new RuntimeException("Expecting 2 parameters for decimal logical type, got " + params.size());
                }
                return LogicalTypeAnnotation.decimalType(Integer.valueOf(params.get(1)), Integer.valueOf(params.get(0)));
            }
        }
        ,
        DATE{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.dateType();
            }
        }
        ,
        TIME{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                if (params.size() != 2) {
                    throw new RuntimeException("Expecting 2 parameters for time logical type, got " + params.size());
                }
                return LogicalTypeAnnotation.timeType(Boolean.parseBoolean(params.get(1)), TimeUnit.valueOf(params.get(0)));
            }
        }
        ,
        TIMESTAMP{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                if (params.size() != 2) {
                    throw new RuntimeException("Expecting 2 parameters for timestamp logical type, got " + params.size());
                }
                return LogicalTypeAnnotation.timestampType(Boolean.parseBoolean(params.get(1)), TimeUnit.valueOf(params.get(0)));
            }
        }
        ,
        INTEGER{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                if (params.size() != 2) {
                    throw new RuntimeException("Expecting 2 parameters for integer logical type, got " + params.size());
                }
                return LogicalTypeAnnotation.intType(Integer.valueOf(params.get(0)), Boolean.parseBoolean(params.get(1)));
            }
        }
        ,
        JSON{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.jsonType();
            }
        }
        ,
        BSON{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.bsonType();
            }
        }
        ,
        UUID{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return LogicalTypeAnnotation.uuidType();
            }
        }
        ,
        INTERVAL{

            @Override
            protected LogicalTypeAnnotation fromString(List<String> params) {
                return IntervalLogicalTypeAnnotation.getInstance();
            }
        };


        protected abstract LogicalTypeAnnotation fromString(List<String> var1);
    }
}

