/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.trino.hive.$internal.com.google.common.base.Preconditions;
import io.trino.hive.$internal.org.apache.commons.logging.Log;
import io.trino.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class VectorPTFEvaluatorDecimalMax
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorDecimalMax.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected HiveDecimalWritable max = new HiveDecimalWritable();
    private static HiveDecimal MIN_VALUE = HiveDecimal.create("-99999999999999999999999999999999999999");

    public VectorPTFEvaluatorDecimalMax(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        block14: {
            DecimalColumnVector decimalColVector;
            int size;
            block13: {
                block15: {
                    this.evaluateInputExpr(batch);
                    Preconditions.checkState(!batch.selectedInUse);
                    size = batch.size;
                    if (size == 0) {
                        return;
                    }
                    decimalColVector = (DecimalColumnVector)batch.cols[this.inputColumnNum];
                    if (!decimalColVector.isRepeating) break block13;
                    if (!decimalColVector.noNulls && decimalColVector.isNull[0]) break block14;
                    if (!this.isGroupResultNull) break block15;
                    this.max.set(decimalColVector.vector[0]);
                    this.isGroupResultNull = false;
                    break block14;
                }
                HiveDecimalWritable repeatedMax = decimalColVector.vector[0];
                if (repeatedMax.compareTo(this.max) != 1) break block14;
                this.max.set(repeatedMax);
                break block14;
            }
            if (decimalColVector.noNulls) {
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    this.max.set(vector[0]);
                    this.isGroupResultNull = false;
                } else {
                    HiveDecimalWritable dec = vector[0];
                    if (dec.compareTo(this.max) == 1) {
                        this.max.set(dec);
                    }
                }
                for (int i = 1; i < size; ++i) {
                    HiveDecimalWritable dec = vector[i];
                    if (dec.compareTo(this.max) != 1) continue;
                    this.max.set(dec);
                }
            } else {
                HiveDecimalWritable dec;
                boolean[] batchIsNull = decimalColVector.isNull;
                int i = 0;
                while (batchIsNull[i]) {
                    if (++i < size) continue;
                    return;
                }
                HiveDecimalWritable[] vector = decimalColVector.vector;
                if (this.isGroupResultNull) {
                    this.max.set(vector[i++]);
                    this.isGroupResultNull = false;
                } else if ((dec = vector[i++]).compareTo(this.max) == 1) {
                    this.max.set(dec);
                }
                while (i < size) {
                    if (!batchIsNull[i] && (dec = vector[i]).compareTo(this.max) == 1) {
                        this.max.set(dec);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DECIMAL;
    }

    @Override
    public HiveDecimalWritable getDecimalGroupResult() {
        return this.max;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.max.set(MIN_VALUE);
    }
}

