/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="current_authorizer", value="_FUNC_() - Returns the current authorizer (class name of the authorizer). ")
@NDV(maxNdv=1L)
public class GenericUDFCurrentAuthorizer
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDFCurrentAuthorizer.class.getName());
    protected Text authorizer;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CurrentAuthorizer does not take any arguments, but found " + arguments.length);
        }
        if (this.authorizer == null) {
            HiveConf hiveConf = SessionState.getSessionConf();
            HiveAuthorizer hiveAuthorizer = SessionState.get().getAuthorizerV2();
            try {
                if (hiveAuthorizer.getHivePolicyProvider() != null) {
                    this.authorizer = new Text(hiveAuthorizer.getHivePolicyProvider().getClass().getSimpleName());
                }
            }
            catch (HiveAuthzPluginException e) {
                LOG.warn("Error getting HivePolicyProvider", e);
            }
            if (this.authorizer == null && MetastoreConf.getVar(hiveConf, MetastoreConf.ConfVars.PRE_EVENT_LISTENERS) != null && !MetastoreConf.getVar(hiveConf, MetastoreConf.ConfVars.PRE_EVENT_LISTENERS).isEmpty() && HiveConf.getVar(hiveConf, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER) != null) {
                try {
                    List<HiveMetastoreAuthorizationProvider> authorizerProviders = HiveUtils.getMetaStoreAuthorizeProviderManagers(hiveConf, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, SessionState.get().getAuthenticator());
                    for (HiveMetastoreAuthorizationProvider authProvider : authorizerProviders) {
                        if (authProvider.getHivePolicyProvider() == null) continue;
                        this.authorizer = new Text(authProvider.getHivePolicyProvider().getClass().getSimpleName());
                        break;
                    }
                }
                catch (HiveAuthzPluginException e) {
                    LOG.warn("Error getting HivePolicyProvider", e);
                }
                catch (HiveException e) {
                    LOG.warn("Error instantiating hive.security.metastore.authorization.manager", e);
                }
            }
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.authorizer;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_AUTHORIZER()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentAuthorizer other = (GenericUDFCurrentAuthorizer)newInstance;
        if (this.authorizer != null) {
            other.authorizer = new Text(this.authorizer);
        }
    }
}

