/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import io.trino.hive.$internal.parquet.org.apache.thrift.TBase;
import io.trino.hive.$internal.parquet.org.apache.thrift.TException;
import io.trino.hive.$internal.parquet.org.apache.thrift.protocol.TCompactProtocol;
import io.trino.hive.$internal.parquet.org.apache.thrift.protocol.TProtocol;
import io.trino.hive.$internal.parquet.org.apache.thrift.transport.TIOStreamTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.InterningProtocol;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.event.Consumers;
import org.apache.parquet.format.event.EventBasedThriftReader;
import org.apache.parquet.format.event.TypedConsumer;

public class Util {
    public static void writeColumnIndex(ColumnIndex columnIndex, OutputStream to) throws IOException {
        Util.write(columnIndex, to);
    }

    public static ColumnIndex readColumnIndex(InputStream from) throws IOException {
        return Util.read(from, new ColumnIndex());
    }

    public static void writeOffsetIndex(OffsetIndex offsetIndex, OutputStream to) throws IOException {
        Util.write(offsetIndex, to);
    }

    public static OffsetIndex readOffsetIndex(InputStream from) throws IOException {
        return Util.read(from, new OffsetIndex());
    }

    public static void writePageHeader(PageHeader pageHeader, OutputStream to) throws IOException {
        Util.write(pageHeader, to);
    }

    public static PageHeader readPageHeader(InputStream from) throws IOException {
        return Util.read(from, new PageHeader());
    }

    public static void writeFileMetaData(FileMetaData fileMetadata, OutputStream to) throws IOException {
        Util.write(fileMetadata, to);
    }

    public static FileMetaData readFileMetaData(InputStream from) throws IOException {
        return Util.read(from, new FileMetaData());
    }

    public static FileMetaData readFileMetaData(InputStream from, boolean skipRowGroups) throws IOException {
        FileMetaData md = new FileMetaData();
        if (skipRowGroups) {
            Util.readFileMetaData(from, new DefaultFileMetaDataConsumer(md), skipRowGroups);
        } else {
            Util.read(from, md);
        }
        return md;
    }

    public static void readFileMetaData(InputStream from, FileMetaDataConsumer consumer) throws IOException {
        Util.readFileMetaData(from, consumer, false);
    }

    public static void readFileMetaData(InputStream from, final FileMetaDataConsumer consumer, boolean skipRowGroups) throws IOException {
        try {
            Consumers.DelegatingFieldConsumer eventConsumer = Consumers.fieldConsumer().onField(FileMetaData._Fields.VERSION, new TypedConsumer.I32Consumer(){

                @Override
                public void consume(int value) {
                    consumer.setVersion(value);
                }
            }).onField(FileMetaData._Fields.SCHEMA, Consumers.listOf(SchemaElement.class, new Consumers.Consumer<List<SchemaElement>>(){

                @Override
                public void consume(List<SchemaElement> schema) {
                    consumer.setSchema(schema);
                }
            })).onField(FileMetaData._Fields.NUM_ROWS, new TypedConsumer.I64Consumer(){

                @Override
                public void consume(long value) {
                    consumer.setNumRows(value);
                }
            }).onField(FileMetaData._Fields.KEY_VALUE_METADATA, Consumers.listElementsOf(Consumers.struct(KeyValue.class, new Consumers.Consumer<KeyValue>(){

                @Override
                public void consume(KeyValue kv) {
                    consumer.addKeyValueMetaData(kv);
                }
            }))).onField(FileMetaData._Fields.CREATED_BY, new TypedConsumer.StringConsumer(){

                @Override
                public void consume(String value) {
                    consumer.setCreatedBy(value);
                }
            });
            if (!skipRowGroups) {
                eventConsumer = eventConsumer.onField(FileMetaData._Fields.ROW_GROUPS, Consumers.listElementsOf(Consumers.struct(RowGroup.class, new Consumers.Consumer<RowGroup>(){

                    @Override
                    public void consume(RowGroup rowGroup) {
                        consumer.addRowGroup(rowGroup);
                    }
                })));
            }
            new EventBasedThriftReader(Util.protocol(from)).readStruct(eventConsumer);
        }
        catch (TException e) {
            throw new IOException("can not read FileMetaData: " + e.getMessage(), e);
        }
    }

    private static TProtocol protocol(OutputStream to) {
        return Util.protocol(new TIOStreamTransport(to));
    }

    private static TProtocol protocol(InputStream from) {
        return Util.protocol(new TIOStreamTransport(from));
    }

    private static InterningProtocol protocol(TIOStreamTransport t) {
        return new InterningProtocol(new TCompactProtocol(t));
    }

    private static <T extends TBase<?, ?>> T read(InputStream from, T tbase) throws IOException {
        try {
            tbase.read(Util.protocol(from));
            return tbase;
        }
        catch (TException e) {
            throw new IOException("can not read " + tbase.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static void write(TBase<?, ?> tbase, OutputStream to) throws IOException {
        try {
            tbase.write(Util.protocol(to));
        }
        catch (TException e) {
            throw new IOException("can not write " + tbase, e);
        }
    }

    public static final class DefaultFileMetaDataConsumer
    extends FileMetaDataConsumer {
        private final FileMetaData md;

        public DefaultFileMetaDataConsumer(FileMetaData md) {
            this.md = md;
        }

        @Override
        public void setVersion(int version) {
            this.md.setVersion(version);
        }

        @Override
        public void setSchema(List<SchemaElement> schema) {
            this.md.setSchema(schema);
        }

        @Override
        public void setNumRows(long numRows) {
            this.md.setNum_rows(numRows);
        }

        @Override
        public void setCreatedBy(String createdBy) {
            this.md.setCreated_by(createdBy);
        }

        @Override
        public void addRowGroup(RowGroup rowGroup) {
            this.md.addToRow_groups(rowGroup);
        }

        @Override
        public void addKeyValueMetaData(KeyValue kv) {
            this.md.addToKey_value_metadata(kv);
        }
    }

    public static abstract class FileMetaDataConsumer {
        public abstract void setVersion(int var1);

        public abstract void setSchema(List<SchemaElement> var1);

        public abstract void setNumRows(long var1);

        public abstract void addRowGroup(RowGroup var1);

        public abstract void addKeyValueMetaData(KeyValue var1);

        public abstract void setCreatedBy(String var1);
    }
}

