/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import java.io.Serializable;
import java.util.Objects;

public final class Options
implements Serializable {
    public static final Options DEFAULT_OPTIONS = Options.builder().build();
    private static final int MINIMUM_NUMBER_OF_DFA_STATES = 2;
    private static final int DEFAULT_NUMBER_OF_DFA_RETRIES = 5;
    private Algorithm algorithm = Algorithm.DFA;
    private EventsListener eventsListener = null;
    private int maximumNumberOfDFAStates = Integer.MAX_VALUE;
    private int numberOfDFARetries = 5;

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public EventsListener getEventsListener() {
        return this.eventsListener;
    }

    public int getMaximumNumberOfDFAStates() {
        return this.maximumNumberOfDFAStates;
    }

    public int getNumberOfDFARetries() {
        return this.numberOfDFARetries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Options options = (Options)o;
        return this.maximumNumberOfDFAStates == options.maximumNumberOfDFAStates && this.numberOfDFARetries == options.numberOfDFARetries && this.algorithm == options.algorithm && !(this.eventsListener == null ? options.eventsListener != null : !this.eventsListener.equals(options.eventsListener));
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = 31 * result + (this.eventsListener != null ? this.eventsListener.hashCode() : 0);
        result = 31 * result + this.maximumNumberOfDFAStates;
        result = 31 * result + this.numberOfDFARetries;
        return result;
    }

    public String toString() {
        return "Options{algorithm=" + this.algorithm + ", eventsListener=" + this.eventsListener + ", maximumNumberOfDFAStates=" + this.maximumNumberOfDFAStates + ", numberOfDFARetries=" + this.numberOfDFARetries + "}";
    }

    public static OptionsBuilder builder() {
        return new OptionsBuilder();
    }

    public static enum Algorithm {
        DFA,
        DFA_FALLBACK_TO_NFA,
        NFA;

    }

    public static interface EventsListener {
        public void fallbackToNFA();
    }

    public static final class OptionsBuilder {
        private Options options = new Options();

        public OptionsBuilder setAlgorithm(Algorithm algorithm) {
            this.options.algorithm = Objects.requireNonNull(algorithm);
            return this;
        }

        public OptionsBuilder setMaximumNumberOfDFAStates(int maximumNumberOfDFAStates) {
            if (maximumNumberOfDFAStates < 2) {
                throw new IllegalArgumentException("maximum number of DFA states must be larger or equal to 2");
            }
            this.options.maximumNumberOfDFAStates = maximumNumberOfDFAStates;
            return this;
        }

        public OptionsBuilder setNumberOfDFARetries(int numberOfDFARetries) {
            if (numberOfDFARetries < 0) {
                throw new IllegalArgumentException("number of DFA retries cannot be below 0");
            }
            this.options.numberOfDFARetries = numberOfDFARetries;
            return this;
        }

        public OptionsBuilder setEventsListener(EventsListener eventsListener) {
            this.options.eventsListener = Objects.requireNonNull(eventsListener);
            return this;
        }

        public Options build() {
            return this.options;
        }
    }
}

