/*
 * Decompiled with CFR 0.152.
 */
package com.google.re2j;

import com.google.re2j.Compiler;
import com.google.re2j.DFA;
import com.google.re2j.DFAMachine;
import com.google.re2j.Machine;
import com.google.re2j.MachineInput;
import com.google.re2j.NFAMachine;
import com.google.re2j.Options;
import com.google.re2j.Parser;
import com.google.re2j.PatternSyntaxException;
import com.google.re2j.Prog;
import com.google.re2j.Regexp;
import com.google.re2j.Simplify;
import com.google.re2j.Utils;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class RE2 {
    static final int FOLD_CASE = 1;
    static final int LITERAL = 2;
    static final int CLASS_NL = 4;
    static final int DOT_NL = 8;
    static final int ONE_LINE = 16;
    static final int NON_GREEDY = 32;
    static final int PERL_X = 64;
    static final int UNICODE_GROUPS = 128;
    static final int WAS_DOLLAR = 256;
    static final int MATCH_NL = 12;
    static final int PERL = 212;
    static final int POSIX = 0;
    final String expr;
    final Prog prog;
    final Prog reverseProg;
    final int cond;
    final int numSubexp;
    final Map<String, Integer> namedGroupIndexes;
    final Options options;
    MatchKind matchKind;
    Slice prefixUTF8;
    boolean prefixComplete;
    final ThreadLocal<NFAMachine> nfaMachine = new ThreadLocal<NFAMachine>(){

        @Override
        protected NFAMachine initialValue() {
            return new NFAMachine(RE2.this);
        }
    };
    volatile DFAMachine dfaMachine;
    AtomicInteger numberOfDFARetriesLeft;

    RE2(RE2 re2) {
        this(re2.expr, re2.prog, re2.reverseProg, re2.numSubexp, re2.namedGroupIndexes, re2.matchKind, re2.options, re2.prefixComplete, re2.prefixUTF8);
    }

    private RE2(String expr, Prog prog, Prog reverseProg, int numSubexp, Map<String, Integer> namedGroupIndexes, MatchKind matchKind, Options options, boolean prefixComplete, Slice prefixUTF8) {
        this.expr = expr;
        this.prog = prog;
        this.reverseProg = reverseProg;
        this.numSubexp = numSubexp;
        this.namedGroupIndexes = namedGroupIndexes;
        this.options = options;
        this.cond = prog.startCond();
        this.matchKind = matchKind;
        this.prefixComplete = prefixComplete;
        this.prefixUTF8 = prefixUTF8;
        if (options.getAlgorithm() == Options.Algorithm.DFA || options.getAlgorithm() == Options.Algorithm.DFA_FALLBACK_TO_NFA) {
            this.dfaMachine = new DFAMachine(this, options.getMaximumNumberOfDFAStates());
            this.numberOfDFARetriesLeft = new AtomicInteger(options.getNumberOfDFARetries());
        }
    }

    static RE2 compile(String expr, Options options) throws PatternSyntaxException {
        return RE2.compileImpl(expr, 212, MatchKind.FIRST_MATCH, options);
    }

    static RE2 compilePOSIX(String expr, Options options) throws PatternSyntaxException {
        return RE2.compileImpl(expr, 0, MatchKind.LONGEST_MATCH, options);
    }

    static RE2 compileImpl(String expr, int mode, MatchKind matchKind, Options options) throws PatternSyntaxException {
        Regexp re = Parser.parse(expr, mode);
        int maxCap = re.maxCap();
        re = Simplify.simplify(re);
        Prog prog = Compiler.compileRegexp(re, false);
        Prog reverseProg = Compiler.compileRegexp(re, true);
        DynamicSliceOutput prefixBuilder = new DynamicSliceOutput(prog.numInst());
        boolean prefixComplete = prog.prefix((SliceOutput)prefixBuilder);
        Slice prefixUTF8 = prefixBuilder.slice();
        return new RE2(expr, prog, reverseProg, maxCap, re.namedGroupIndexes(), matchKind, options, prefixComplete, prefixUTF8);
    }

    int numberOfCapturingGroups() {
        return this.numSubexp;
    }

    public String toString() {
        return this.expr;
    }

    private int[] doExecute(MachineInput in, int pos, Anchor anchor, int ncap) {
        DFAMachine currentDFAMachine = this.dfaMachine;
        if (currentDFAMachine == null) {
            return this.doExecute(this.nfaMachine.get(), in, pos, anchor, ncap);
        }
        try {
            return this.doExecute(currentDFAMachine, in, pos, anchor, ncap);
        }
        catch (DFA.DFATooManyStatesException e) {
            this.handleTooManyDFAStatesException(e, currentDFAMachine);
            return this.doExecute(this.nfaMachine.get(), in, pos, anchor, ncap);
        }
    }

    private int[] doExecute(Machine machine, MachineInput in, int pos, Anchor anchor, int ncap) {
        int[] submatches = new int[ncap];
        return (int[])(machine.match(in, pos, anchor, submatches) ? submatches : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void handleTooManyDFAStatesException(DFA.DFATooManyStatesException e, DFAMachine currentDFAMachine) {
        if (currentDFAMachine != this.dfaMachine) return;
        if (this.numberOfDFARetriesLeft.decrementAndGet() < 0) {
            if (this.options.getAlgorithm() != Options.Algorithm.DFA_FALLBACK_TO_NFA) throw e;
            this.dfaMachine = null;
            if (this.options.getEventsListener() == null) return;
            this.options.getEventsListener().fallbackToNFA();
            return;
        } else {
            this.dfaMachine = new DFAMachine(this, this.options.getMaximumNumberOfDFAStates());
        }
    }

    boolean match(Slice s) {
        return this.doExecute(MachineInput.fromUTF8(s), 0, Anchor.UNANCHORED, 0) != null;
    }

    boolean match(Slice input, int start, Anchor anchor, int[] group, int ngroup) {
        if (start > input.length()) {
            return false;
        }
        int[] groupMatch = this.doExecute(MachineInput.fromUTF8(input), start, anchor, 2 * ngroup);
        if (groupMatch == null) {
            return false;
        }
        if (group != null) {
            System.arraycopy(groupMatch, 0, group, 0, groupMatch.length);
        }
        return true;
    }

    static boolean match(String pattern, Slice s, Options options) throws PatternSyntaxException {
        return RE2.compile(pattern, options).match(s);
    }

    Slice replaceAll(Slice src, final Slice repl) {
        return this.replaceAllFunc(src, new ReplaceFunc(){

            @Override
            public Slice replace(Slice orig) {
                return repl;
            }
        }, 2 * src.length() + 1);
    }

    Slice replaceFirst(Slice src, final Slice repl) {
        return this.replaceAllFunc(src, new ReplaceFunc(){

            @Override
            public Slice replace(Slice orig) {
                return repl;
            }
        }, 1);
    }

    Slice replaceAllFunc(Slice src, ReplaceFunc repl, int maxReplaces) {
        int[] a;
        int lastMatchEnd = 0;
        int searchPos = 0;
        DynamicSliceOutput buf = new DynamicSliceOutput(src.length());
        MachineInput input = MachineInput.fromUTF8(src);
        int numReplaces = 0;
        while (searchPos <= src.length() && (a = this.doExecute(input, searchPos, Anchor.UNANCHORED, 2)) != null && a.length != 0) {
            buf.writeBytes(src, lastMatchEnd, a[0] - lastMatchEnd);
            if (a[1] > lastMatchEnd || a[0] == 0) {
                buf.writeBytes(repl.replace(src.slice(a[0], a[1] - a[0])));
                ++numReplaces;
            }
            lastMatchEnd = a[1];
            searchPos = searchPos + 1 > a[1] ? ++searchPos : a[1];
            if (numReplaces < maxReplaces) continue;
            break;
        }
        buf.writeBytes(src, lastMatchEnd, src.length() - lastMatchEnd);
        return buf.slice();
    }

    static String quoteMeta(String s) {
        StringBuilder b = new StringBuilder(2 * s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("\\.+*?()|[]{}^$".indexOf(c) >= 0) {
                b.append('\\');
            }
            b.append(c);
        }
        return b.toString();
    }

    private int[] pad(int[] a) {
        if (a == null) {
            return null;
        }
        int n = (1 + this.numSubexp) * 2;
        if (a.length < n) {
            int[] a2 = new int[n];
            System.arraycopy(a, 0, a2, 0, a.length);
            Arrays.fill(a2, a.length, n, -1);
            a = a2;
        }
        return a;
    }

    private void allMatches(MachineInput input, int n, DeliverFunc deliver) {
        int[] matches;
        int end = input.endPos();
        if (n < 0) {
            n = end + 1;
        }
        int pos = 0;
        int i = 0;
        int prevMatchEnd = -1;
        while (i < n && pos <= end && (matches = this.doExecute(input, pos, Anchor.UNANCHORED, this.prog.numCap)) != null && matches.length != 0) {
            boolean accept = true;
            if (matches[1] == pos) {
                byte b;
                if (matches[0] == prevMatchEnd) {
                    accept = false;
                }
                pos = (b = input.getByte(pos)) == -1 ? end + 1 : ++pos;
            } else {
                pos = matches[1];
            }
            prevMatchEnd = matches[1];
            if (!accept) continue;
            deliver.deliver(this.pad(matches));
            ++i;
        }
    }

    Slice find(Slice s) {
        int[] a = this.doExecute(MachineInput.fromUTF8(s), 0, Anchor.UNANCHORED, 2);
        if (a == null) {
            return Slices.EMPTY_SLICE;
        }
        return s.slice(a[0], a[1] - a[0]);
    }

    int[] findIndex(Slice s) {
        int[] a = this.doExecute(MachineInput.fromUTF8(s), 0, Anchor.UNANCHORED, 2);
        if (a == null) {
            return null;
        }
        return a;
    }

    Slice[] findSubmatch(Slice s) {
        int[] a = this.doExecute(MachineInput.fromUTF8(s), 0, Anchor.UNANCHORED, this.prog.numCap);
        if (a == null) {
            return null;
        }
        Slice[] ret = new Slice[1 + this.numSubexp];
        for (int i = 0; i < ret.length; ++i) {
            if (2 * i >= a.length || a[2 * i] < 0) continue;
            int begin = a[2 * i];
            int end = a[2 * i + 1];
            ret[i] = s.slice(begin, end - begin);
        }
        return ret;
    }

    int[] findSubmatchIndex(Slice s) {
        return this.pad(this.doExecute(MachineInput.fromUTF8(s), 0, Anchor.UNANCHORED, this.prog.numCap));
    }

    List<Slice> findAll(final Slice s, int n) {
        final ArrayList<Slice> result = new ArrayList<Slice>();
        this.allMatches(MachineInput.fromUTF8(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(s.slice(match[0], match[1] - match[0]));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllIndex(Slice s, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF8(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(Utils.subarray(match, 0, 2));
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<Slice[]> findAllSubmatch(final Slice s, int n) {
        final ArrayList<Slice[]> result = new ArrayList<Slice[]>();
        this.allMatches(MachineInput.fromUTF8(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                Slice[] slice = new Slice[match.length / 2];
                for (int j = 0; j < slice.length; ++j) {
                    if (match[2 * j] < 0) continue;
                    int begin = match[2 * j];
                    int end = match[2 * j + 1];
                    slice[j] = s.slice(begin, end - begin);
                }
                result.add(slice);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    List<int[]> findAllSubmatchIndex(Slice s, int n) {
        final ArrayList<int[]> result = new ArrayList<int[]>();
        this.allMatches(MachineInput.fromUTF8(s), n, new DeliverFunc(){

            @Override
            public void deliver(int[] match) {
                result.add(match);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    static enum MatchKind {
        FIRST_MATCH,
        LONGEST_MATCH;

    }

    static enum Anchor {
        UNANCHORED,
        ANCHOR_START,
        ANCHOR_BOTH;


        boolean isUnanchored() {
            return this == UNANCHORED;
        }

        boolean isAnchorEnd() {
            return this == ANCHOR_BOTH;
        }

        boolean isAnchorStart() {
            return this == ANCHOR_START || this == ANCHOR_BOTH;
        }

        boolean isAnchorBoth() {
            return this == ANCHOR_BOTH;
        }
    }

    static interface ReplaceFunc {
        public Slice replace(Slice var1);
    }

    private static interface DeliverFunc {
        public void deliver(int[] var1);
    }
}

