/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.table.kafka;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class KafkaMessageContentsBuilder {
    private final ByteArrayOutputStream contents = new ByteArrayOutputStream();

    public static KafkaMessageContentsBuilder contentsBuilder() {
        return new KafkaMessageContentsBuilder();
    }

    public KafkaMessageContentsBuilder appendBytes(byte[] bytes) {
        try {
            this.contents.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public KafkaMessageContentsBuilder appendBytes(int ... bytes) {
        for (int b : bytes) {
            Preconditions.checkArgument((b >= 0 && b <= 255 ? 1 : 0) != 0, (Object)"Byte must be in 0-255 range");
            this.contents.write(b);
        }
        return this;
    }

    public KafkaMessageContentsBuilder appendIntBigEndian(int v) {
        for (int i = 3; i >= 0; --i) {
            this.contents.write(v >> i * 8 & 0xFF);
        }
        return this;
    }

    public KafkaMessageContentsBuilder appendLongBigEndian(long v) {
        for (int i = 7; i >= 0; --i) {
            this.contents.write((int)(v >> i * 8 & 0xFFL));
        }
        return this;
    }

    public KafkaMessageContentsBuilder appendUTF8(String s) {
        return this.appendBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] build() {
        return this.contents.toByteArray();
    }
}

