/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.table.kafka;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.inject.Injector;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.TableInstance;
import io.trino.tempto.fulfillment.table.TableManager;
import io.trino.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.trino.tempto.fulfillment.table.kafka.KafkaMessage;
import io.trino.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.trino.tempto.fulfillment.table.kafka.KafkaTableInstance;
import io.trino.tempto.internal.fulfillment.table.TableName;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

@TableManager.Descriptor(tableDefinitionClass=KafkaTableDefinition.class, type="KAFKA")
@Singleton
public class KafkaTableManager
implements TableManager<KafkaTableDefinition> {
    private final String databaseName;
    private final Configuration brokerConfiguration;

    @Inject
    public KafkaTableManager(@Named(value="databaseName") String databaseName, @Named(value="broker") Configuration brokerConfiguration, Injector injector) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.brokerConfiguration = Objects.requireNonNull(brokerConfiguration, "brokerConfiguration is null");
        Objects.requireNonNull(injector, "injector is null");
    }

    public TableInstance<KafkaTableDefinition> createImmutable(KafkaTableDefinition tableDefinition, TableHandle tableHandle) {
        this.deleteTopic(tableDefinition.getTopic());
        this.createTopic(tableDefinition.getTopic(), tableDefinition.getPartitionsCount(), tableDefinition.getReplicationLevel());
        this.insertDataIntoTopic(tableDefinition.getTopic(), tableDefinition.getDataSource());
        TableName createdTableName = new TableName(tableHandle.getDatabase().orElse(this.getDatabaseName()), tableHandle.getSchema(), tableHandle.getName(), tableHandle.getName());
        return new KafkaTableInstance(createdTableName, tableDefinition);
    }

    private void deleteTopic(String topic) {
        try (AdminClient kafkaAdminClient = this.getAdminClient();){
            ListTopicsResult topics = kafkaAdminClient.listTopics();
            Set names = (Set)topics.names().get();
            if (names.contains(topic)) {
                kafkaAdminClient.deleteTopics((Collection)ImmutableList.of((Object)topic)).all().get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete topic " + topic, e);
        }
    }

    private void createTopic(String topic, int partitionsCount, int replicationLevel) {
        try (AdminClient kafkaAdminClient = this.getAdminClient();){
            kafkaAdminClient.createTopics((Collection)ImmutableList.of((Object)new NewTopic(topic, partitionsCount, Shorts.checkedCast((long)replicationLevel)))).all().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void insertDataIntoTopic(String topic, KafkaDataSource dataSource) {
        KafkaProducer producer = new KafkaProducer(this.getKafkaProperties());
        Iterator<KafkaMessage> messages = dataSource.getMessages();
        while (messages.hasNext()) {
            KafkaMessage message = messages.next();
            try {
                producer.send(new ProducerRecord(topic, message.getPartition().isPresent() ? Integer.valueOf(message.getPartition().getAsInt()) : null, (Object)message.getKey().orElse(null), (Object)message.getValue())).get();
            }
            catch (Exception e) {
                throw new RuntimeException("could not send message to topic " + topic);
            }
        }
    }

    private Properties getKafkaProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerConfiguration.getStringMandatory("host") + ":" + this.brokerConfiguration.getIntMandatory("port"));
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        for (String key : this.brokerConfiguration.listKeys()) {
            if (key.equals("host") || key.equals("port")) continue;
            props.put(key, this.brokerConfiguration.getStringMandatory(key));
        }
        return props;
    }

    public TableInstance<KafkaTableDefinition> createMutable(KafkaTableDefinition tableDefinition, MutableTableRequirement.State state, TableHandle tableHandle) {
        throw new IllegalArgumentException("Mutable tables are not supported by KafkaTableManager");
    }

    public void dropTable(TableName tableName) {
        throw new IllegalArgumentException("dropTable not supported by KafkaTableManager");
    }

    public void dropStaleMutableTables() {
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Class<? extends TableDefinition> getTableDefinitionClass() {
        return KafkaTableDefinition.class;
    }

    private AdminClient getAdminClient() {
        return KafkaAdminClient.create((Properties)this.getKafkaProperties());
    }
}

