/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.table.kafka;

import com.google.common.base.Preconditions;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableHandle;
import io.trino.tempto.fulfillment.table.kafka.KafkaDataSource;
import java.util.Objects;

public class KafkaTableDefinition
extends TableDefinition {
    private final String topic;
    private final KafkaDataSource dataSource;
    private final int partitionsCount;
    private final int replicationLevel;

    public KafkaTableDefinition(String name, String topic, KafkaDataSource dataSource, int partitionsCount, int replicationLevel) {
        super(TableHandle.parse((String)Objects.requireNonNull(name, "name is null")));
        this.topic = Objects.requireNonNull(topic, "topic is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        Preconditions.checkArgument((partitionsCount >= 1 ? 1 : 0) != 0, (Object)"partitionsCount must be grater than or equal 1");
        this.partitionsCount = partitionsCount;
        Preconditions.checkArgument((replicationLevel >= 1 ? 1 : 0) != 0, (Object)"replicationLevel must be grater than or equal 1");
        this.replicationLevel = replicationLevel;
    }

    public String getTopic() {
        return this.topic;
    }

    public KafkaDataSource getDataSource() {
        return this.dataSource;
    }

    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public int getReplicationLevel() {
        return this.replicationLevel;
    }
}

