/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.table.kafka;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class KafkaMessage {
    private final OptionalInt partition;
    private final Optional<byte[]> key;
    private final byte[] value;

    public KafkaMessage(byte[] value) {
        this(Optional.empty(), value, OptionalInt.empty());
    }

    public KafkaMessage(byte[] value, OptionalInt partition) {
        this(Optional.empty(), value, partition);
    }

    public KafkaMessage(byte[] key, byte[] value) {
        this(Optional.of(key), value, OptionalInt.empty());
    }

    public KafkaMessage(Optional<byte[]> key, byte[] value, OptionalInt partition) {
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.key = Objects.requireNonNull(key, "key is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public OptionalInt getPartition() {
        return this.partition;
    }

    public Optional<byte[]> getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }
}

