/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.ldap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LdapObjectDefinition {
    private final String id;
    private final String distinguishedName;
    private final Map<String, String> attributes;
    private final List<String> objectClasses;
    private final Map<String, List<String>> modificationAttributes;

    private LdapObjectDefinition(String id, String distinguishedName, Map<String, String> attributes, Map<String, List<String>> modificationAttributes, List<String> objectClasses) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.distinguishedName = Objects.requireNonNull(distinguishedName, "distinguishedName is null");
        this.attributes = ImmutableMap.copyOf(Objects.requireNonNull(attributes, "attributes is null"));
        this.modificationAttributes = ImmutableMap.copyOf(Objects.requireNonNull(modificationAttributes, "modificationAttributes is null"));
        this.objectClasses = ImmutableList.copyOf((Collection)Objects.requireNonNull(objectClasses, "objectClasses is null"));
    }

    public static LdapObjectDefinitionBuilder builder(String id) {
        return new LdapObjectDefinitionBuilder(id);
    }

    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getId() {
        return this.id;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public Map<String, List<String>> getModificationAttributes() {
        return this.modificationAttributes;
    }

    public static class LdapObjectDefinitionBuilder {
        private String id;
        private String distinguishedName;
        private List<String> objectClasses;
        private Map<String, String> attributes;
        private Map<String, List<String>> modificationAttributes;

        private LdapObjectDefinitionBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id is null");
        }

        public LdapObjectDefinition build() {
            return new LdapObjectDefinition(this.id, this.distinguishedName, this.attributes, (Map<String, List<String>>)(this.modificationAttributes == null ? ImmutableMap.of() : this.modificationAttributes), this.objectClasses);
        }

        public LdapObjectDefinitionBuilder setDistinguishedName(String distinguishedName) {
            this.distinguishedName = distinguishedName;
            return this;
        }

        public LdapObjectDefinitionBuilder setAttributes(Map<String, String> attributes) {
            this.attributes = ImmutableMap.copyOf(attributes);
            return this;
        }

        public LdapObjectDefinitionBuilder setModificationAttributes(Map<String, List<String>> modificationAttributes) {
            this.modificationAttributes = ImmutableMap.copyOf(modificationAttributes);
            return this;
        }

        public LdapObjectDefinitionBuilder setObjectClasses(List<String> objectClasses) {
            this.objectClasses = ImmutableList.copyOf(objectClasses);
            return this;
        }
    }
}

