/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.fulfillment.ldap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.tempto.fulfillment.ldap.LdapObjectDefinition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenLdapObjectDefinitions {
    public static final LdapObjectDefinition TEST_ORG = LdapObjectDefinition.builder("TestOrg").setDistinguishedName("ou=Test,dc=tempto,dc=com").setAttributes(Maps.newHashMap()).setObjectClasses(Arrays.asList("organizationalUnit")).build();
    public static final LdapObjectDefinition TEST_GROUP = LdapObjectDefinition.builder("TestGroup").setDistinguishedName("cn=TestGroup,ou=Test,dc=tempto,dc=com").setAttributes(OpenLdapObjectDefinitions.testGroupAttributes()).setObjectClasses(Arrays.asList("groupOfNames")).build();
    public static final LdapObjectDefinition TEST_USER = LdapObjectDefinition.builder("TestUser").setDistinguishedName("uid=testuser,ou=Test,dc=tempto,dc=com").setAttributes(OpenLdapObjectDefinitions.testUserAttributes()).setModificationAttributes((Map<String, List<String>>)ImmutableMap.of((Object)"memberOf", (Object)ImmutableList.of((Object)"cn=TestGroup,ou=Test,dc=tempto,dc=com"))).setObjectClasses(Arrays.asList("person", "inetOrgPerson")).build();

    private static Map<String, String> testGroupAttributes() {
        HashMap attributes = Maps.newHashMap();
        attributes.put("cn", "Test Group");
        attributes.put("member", "uid=testuser,ou=Test,dc=tempto,dc=com");
        return attributes;
    }

    private static Map<String, String> testUserAttributes() {
        HashMap attributes = Maps.newHashMap();
        attributes.put("cn", "Test User");
        attributes.put("sn", "User");
        attributes.put("password", "testp@ss");
        return attributes;
    }
}

