/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.runner;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TemptoRunnerOptions {
    public static final Option PACKAGE = Option.builder((String)"p").longOpt("package").desc("Java package to be scanned for tests").hasArg().required().build();
    public static final Option CONFIG_FILES = Option.builder((String)"f").longOpt("config").desc("Path to test configuration YAML files. If file does not exists in local file system then classpath is checked").valueSeparator(',').hasArg().build();
    public static final Option REPORT_DIR = Option.builder((String)"r").longOpt("report-dir").desc("Test reports directory").hasArg().build();
    public static final Option CONVENTION_TESTS_DIR = Option.builder((String)"c").longOpt("convention-test-dir").desc("Convention test directory. If not found in local file system then classpath is checked.").hasArg().build();
    public static final Option GROUPS = Option.builder((String)"g").longOpt("groups").desc("Test groups to be run").valueSeparator(',').hasArg().build();
    public static final Option EXCLUDED_GROUPS = Option.builder((String)"x").longOpt("excluded-groups").desc("Test groups to be excluded").valueSeparator(',').hasArg().build();
    public static final Option TESTS = Option.builder((String)"t").longOpt("tests").desc("Comma-separated list of values which are substring-matched against test names").valueSeparator(',').hasArg().build();
    public static final Option EXCLUDED_TESTS = Option.builder((String)"e").longOpt("excluded-tests").desc("Test name structural prefix (dot-separated) to be excluded").valueSeparator(',').hasArg().build();
    public static final Option HELP = Option.builder((String)"h").longOpt("help").build();
    public static final Option DUMP_CONVENTION_RESULTS = Option.builder().longOpt("dump-convention-results").desc("Dump results of convention based test queries to directory.").hasArg().build();
    public static final Option THREAD_COUNT = Option.builder().longOpt("thread-count").desc("Number of threads which will execute tests.").hasArg().build();
    private final Map<String, String> values;

    public TemptoRunnerOptions(Map<String, String> values) {
        Objects.requireNonNull(values, "values is null");
        this.values = ImmutableMap.copyOf(values);
    }

    public String getReportDir() {
        return this.getValue(REPORT_DIR.getLongOpt()).get();
    }

    public Set<String> getTestsPackage() {
        return this.getValues(PACKAGE.getLongOpt());
    }

    public String getConfigFiles() {
        return this.getValue(CONFIG_FILES.getLongOpt()).get();
    }

    public Set<String> getTestGroups() {
        return this.getValues(GROUPS.getLongOpt());
    }

    public String getConventionTestsDirectory() {
        return this.getValue(CONVENTION_TESTS_DIR.getLongOpt()).get();
    }

    public Set<String> getExcludeGroups() {
        return this.getValues(EXCLUDED_GROUPS.getLongOpt());
    }

    public Set<String> getTests() {
        return this.getValues(TESTS.getLongOpt());
    }

    public Set<String> getExcludedTests() {
        return this.getValues(EXCLUDED_TESTS.getLongOpt());
    }

    public boolean isHelpRequested() {
        return this.isSet(HELP);
    }

    public Optional<String> getConventionResultsDumpPath() {
        return this.getValue(DUMP_CONVENTION_RESULTS.getLongOpt());
    }

    public int getThreadCount() {
        return Integer.parseInt(this.getValue(THREAD_COUNT.getLongOpt()).orElse("1"));
    }

    public Set<String> getValues(String option) {
        return (Set)this.getValue(option).map(v -> ImmutableSet.copyOf((Collection)Splitter.on((char)',').omitEmptyStrings().trimResults().splitToList((CharSequence)v))).orElse(ImmutableSet.of());
    }

    public Optional<String> getValue(String option) {
        return Optional.ofNullable(this.values.get(option));
    }

    public boolean isSet(Option option) {
        return this.getValue(option.getLongOpt()).map(v -> v.equals(Boolean.TRUE.toString())).orElse(false);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

