/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tempto.runner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.tempto.runner.TemptoRunnerOptions;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TemptoRunnerCommandLineParser {
    private static final Comparator<Option> OPTION_BY_LONG_OPT_COMPARATOR = Comparator.comparing(Option::getLongOpt);
    private final String appName;
    private final List<Option> options;
    private final Map<String, DefaultValue> defaults;

    private TemptoRunnerCommandLineParser(String appName, List<Option> options, Map<String, DefaultValue> defaults) {
        Objects.requireNonNull(appName, "appName is null");
        Objects.requireNonNull(options, "options is null");
        Objects.requireNonNull(defaults, "defaults is null");
        this.appName = appName;
        this.options = ImmutableList.copyOf(options);
        this.defaults = ImmutableMap.copyOf(defaults);
    }

    public TemptoRunnerOptions parseCommandLine(String[] argv) {
        Options options = this.buildOptions();
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine commandLine = parser.parse(options, argv);
            return this.commandLineToOptions(commandLine);
        }
        catch (ParseException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    public void printHelpMessage() {
        this.printHelpMessage(new PrintWriter(System.err));
    }

    public void printHelpMessage(PrintWriter printWriter) {
        Options options = this.buildOptions();
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(OPTION_BY_LONG_OPT_COMPARATOR);
        helpFormatter.printHelp(printWriter, 120, this.appName, null, options, 1, 3, null);
        printWriter.flush();
    }

    private Options buildOptions() {
        Options options = new Options();
        for (Option option : this.options) {
            if (!this.isChangable(option.getLongOpt())) continue;
            options.addOption(option);
        }
        return options;
    }

    private boolean isChangable(String option) {
        return !this.defaults.containsKey(option) || this.defaults.get(option).isChangeable();
    }

    private TemptoRunnerOptions commandLineToOptions(CommandLine commandLine) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        if (!commandLine.getArgList().isEmpty()) {
            throw new ParsingException("Extra unsupported parameters: " + commandLine.getArgList());
        }
        for (Option option : this.options) {
            Optional<String> value = this.getOptionValue(commandLine, option);
            if (!value.isPresent()) continue;
            values.put((Object)option.getLongOpt(), (Object)value.get());
        }
        return new TemptoRunnerOptions((Map<String, String>)values.build());
    }

    private Optional<String> getOptionValue(CommandLine commandLine, Option option) {
        String longOpt = option.getLongOpt();
        if (this.defaults.containsKey(longOpt)) {
            return Optional.of(commandLine.getOptionValue(longOpt, this.defaults.get(longOpt).getValue()));
        }
        Optional<String> value = Optional.ofNullable(commandLine.getOptionValue(longOpt));
        if (!value.isPresent() && commandLine.hasOption(longOpt)) {
            return Optional.of(Boolean.TRUE.toString());
        }
        return value;
    }

    public static Builder builder(String appName) {
        return new Builder(appName);
    }

    public static class ParsingException
    extends RuntimeException {
        public ParsingException(String message) {
            super(message);
        }

        public ParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class DefaultValue {
        private final String value;
        private final boolean changeable;

        private DefaultValue(String value, boolean changeable) {
            this.value = value;
            this.changeable = changeable;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isChangeable() {
            return this.changeable;
        }
    }

    public static class Builder {
        private final String appName;
        private final List<Option> options = new ArrayList<Option>();
        private final Map<String, DefaultValue> defaults = new HashMap<String, DefaultValue>();

        private Builder(String appName) {
            this.appName = appName;
            this.addOption(TemptoRunnerOptions.EXCLUDED_GROUPS);
            this.addOption(TemptoRunnerOptions.GROUPS);
            this.addOption(TemptoRunnerOptions.PACKAGE);
            this.addOption(TemptoRunnerOptions.REPORT_DIR);
            this.addOption(TemptoRunnerOptions.TESTS);
            this.addOption(TemptoRunnerOptions.EXCLUDED_TESTS);
            this.addOption(TemptoRunnerOptions.HELP);
            this.addOption(TemptoRunnerOptions.DUMP_CONVENTION_RESULTS);
            this.addOption(TemptoRunnerOptions.THREAD_COUNT);
            this.addOption(TemptoRunnerOptions.PARALLEL);
            this.setReportDir("./test-reports", true);
            this.setConfigFile("tempto-configuration.yaml", true);
            this.setConventionTestDirectory("sql-tests", true);
        }

        public Builder addOption(Option option) {
            Preconditions.checkArgument((!this.contains(option) ? 1 : 0) != 0, (String)"Options %s is already added", (Object)option.getLongOpt());
            this.options.add(option);
            return this;
        }

        private boolean contains(Option option) {
            return this.options.stream().anyMatch(o -> o.getLongOpt().equals(option.getLongOpt()));
        }

        public Builder setTestsPackage(String testsPackage, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.PACKAGE, testsPackage, changeable);
        }

        public Builder setConfigFile(String configFile, boolean changeable) {
            return this.setConfigFiles(Collections.singletonList(configFile), changeable);
        }

        public Builder setConfigFiles(List<String> configFiles, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.CONFIG_FILES, Joiner.on((String)",").join(configFiles), changeable);
        }

        public Builder setReportDir(String reportDir, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.REPORT_DIR, reportDir, changeable);
        }

        private Builder setConventionTestDirectory(String conventionTestsDir, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.CONVENTION_TESTS_DIR, conventionTestsDir, changeable);
        }

        public Builder setExcludedGroups(String excludedGroups, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.EXCLUDED_GROUPS, excludedGroups, changeable);
        }

        public Builder setGroups(String groups, boolean changeable) {
            return this.setDefaultValue(TemptoRunnerOptions.GROUPS, groups, changeable);
        }

        public Builder setDefaultValue(Option option, Object value) {
            return this.setDefaultValue(option, value.toString(), true);
        }

        private Builder setDefaultValue(Option option, String value, boolean changeable) {
            if (!this.contains(option)) {
                this.addOption(option);
            }
            this.defaults.put(option.getLongOpt(), new DefaultValue(value.toString(), changeable));
            return this;
        }

        public TemptoRunnerCommandLineParser build() {
            return new TemptoRunnerCommandLineParser(this.appName, this.options, this.defaults);
        }
    }
}

