/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.serializers;

import io.airlift.slice.Slice;
import io.trino.plugin.accumulo.Types;
import io.trino.plugin.accumulo.io.AccumuloPageSink;
import io.trino.plugin.accumulo.serializers.AccumuloRowSerializer;
import io.trino.plugin.accumulo.serializers.BooleanLexicoder;
import io.trino.plugin.accumulo.serializers.MapLexicoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.lexicoder.BytesLexicoder;
import org.apache.accumulo.core.client.lexicoder.DoubleLexicoder;
import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.client.lexicoder.ListLexicoder;
import org.apache.accumulo.core.client.lexicoder.LongLexicoder;
import org.apache.accumulo.core.client.lexicoder.StringLexicoder;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class LexicoderRowSerializer
implements AccumuloRowSerializer {
    private static final Map<Type, Lexicoder> LEXICODER_MAP = new HashMap<Type, Lexicoder>();
    private static final Map<Type, ListLexicoder<?>> LIST_LEXICODERS = new HashMap();
    private static final Map<Type, MapLexicoder<?, ?>> MAP_LEXICODERS = new HashMap();
    private final Map<String, Map<String, String>> familyQualifierColumnMap = new HashMap<String, Map<String, String>>();
    private final Map<String, byte[]> columnValues = new HashMap<String, byte[]>();
    private final Text rowId = new Text();
    private final Text family = new Text();
    private final Text qualifier = new Text();
    private final Text value = new Text();
    private boolean rowOnly;
    private String rowIdName;

    @Override
    public void setRowIdName(String name) {
        this.rowIdName = name;
    }

    @Override
    public void setRowOnly(boolean rowOnly) {
        this.rowOnly = rowOnly;
    }

    @Override
    public void setMapping(String name, String family, String qualifier) {
        this.columnValues.put(name, null);
        Map<String, String> qualifierToNameMap = this.familyQualifierColumnMap.get(family);
        if (qualifierToNameMap == null) {
            qualifierToNameMap = new HashMap<String, String>();
            this.familyQualifierColumnMap.put(family, qualifierToNameMap);
        }
        qualifierToNameMap.put(qualifier, name);
    }

    @Override
    public void reset() {
        this.columnValues.clear();
    }

    @Override
    public void deserialize(Map.Entry<Key, Value> entry) {
        if (!this.columnValues.containsKey(this.rowIdName)) {
            entry.getKey().getRow(this.rowId);
            this.columnValues.put(this.rowIdName, this.rowId.copyBytes());
        }
        if (this.rowOnly) {
            return;
        }
        entry.getKey().getColumnFamily(this.family);
        entry.getKey().getColumnQualifier(this.qualifier);
        if (this.family.equals((Object)AccumuloPageSink.ROW_ID_COLUMN) && this.qualifier.equals((Object)AccumuloPageSink.ROW_ID_COLUMN)) {
            return;
        }
        this.value.set(entry.getValue().get());
        this.columnValues.put(this.familyQualifierColumnMap.get(this.family.toString()).get(this.qualifier.toString()), this.value.copyBytes());
    }

    @Override
    public boolean isNull(String name) {
        return this.columnValues.get(name) == null;
    }

    @Override
    public Block getArray(String name, Type type) {
        Type elementType = Types.getElementType(type);
        return AccumuloRowSerializer.getBlockFromArray(elementType, (List)this.decode(type, this.getFieldValue(name)));
    }

    @Override
    public void setArray(Text text, Type type, Block block) {
        text.set(this.encode(type, block));
    }

    @Override
    public boolean getBoolean(String name) {
        return (Boolean)this.decode((Type)BooleanType.BOOLEAN, this.getFieldValue(name));
    }

    @Override
    public void setBoolean(Text text, Boolean value) {
        text.set(this.encode((Type)BooleanType.BOOLEAN, value));
    }

    @Override
    public byte getByte(String name) {
        return ((Long)this.decode((Type)TinyintType.TINYINT, this.getFieldValue(name))).byteValue();
    }

    @Override
    public void setByte(Text text, Byte value) {
        text.set(this.encode((Type)TinyintType.TINYINT, value));
    }

    @Override
    public Date getDate(String name) {
        return new Date(TimeUnit.DAYS.toMillis((Long)this.decode((Type)BigintType.BIGINT, this.getFieldValue(name))));
    }

    @Override
    public void setDate(Text text, Date value) {
        text.set(this.encode((Type)DateType.DATE, value));
    }

    @Override
    public double getDouble(String name) {
        return (Double)this.decode((Type)DoubleType.DOUBLE, this.getFieldValue(name));
    }

    @Override
    public void setDouble(Text text, Double value) {
        text.set(this.encode((Type)DoubleType.DOUBLE, value));
    }

    @Override
    public float getFloat(String name) {
        return ((Double)this.decode((Type)RealType.REAL, this.getFieldValue(name))).floatValue();
    }

    @Override
    public void setFloat(Text text, Float value) {
        text.set(this.encode((Type)RealType.REAL, value));
    }

    @Override
    public int getInt(String name) {
        return ((Long)this.decode((Type)IntegerType.INTEGER, this.getFieldValue(name))).intValue();
    }

    @Override
    public void setInt(Text text, Integer value) {
        text.set(this.encode((Type)IntegerType.INTEGER, value));
    }

    @Override
    public long getLong(String name) {
        return (Long)this.decode((Type)BigintType.BIGINT, this.getFieldValue(name));
    }

    @Override
    public void setLong(Text text, Long value) {
        text.set(this.encode((Type)BigintType.BIGINT, value));
    }

    @Override
    public Block getMap(String name, Type type) {
        return AccumuloRowSerializer.getBlockFromMap(type, (Map)this.decode(type, this.getFieldValue(name)));
    }

    @Override
    public void setMap(Text text, Type type, Block block) {
        text.set(this.encode(type, block));
    }

    @Override
    public short getShort(String name) {
        return ((Long)this.decode((Type)SmallintType.SMALLINT, this.getFieldValue(name))).shortValue();
    }

    @Override
    public void setShort(Text text, Short value) {
        text.set(this.encode((Type)SmallintType.SMALLINT, value));
    }

    @Override
    public Time getTime(String name) {
        return new Time((Long)this.decode((Type)BigintType.BIGINT, this.getFieldValue(name)));
    }

    @Override
    public void setTime(Text text, Time value) {
        text.set(this.encode((Type)TimeType.TIME, value));
    }

    @Override
    public Timestamp getTimestamp(String name) {
        return new Timestamp((Long)this.decode((Type)TimestampType.TIMESTAMP_MILLIS, this.getFieldValue(name)));
    }

    @Override
    public void setTimestamp(Text text, Timestamp value) {
        text.set(this.encode((Type)TimestampType.TIMESTAMP_MILLIS, value));
    }

    @Override
    public byte[] getVarbinary(String name) {
        return (byte[])this.decode((Type)VarbinaryType.VARBINARY, this.getFieldValue(name));
    }

    @Override
    public void setVarbinary(Text text, byte[] value) {
        text.set(this.encode((Type)VarbinaryType.VARBINARY, value));
    }

    @Override
    public String getVarchar(String name) {
        return (String)this.decode((Type)VarcharType.VARCHAR, this.getFieldValue(name));
    }

    @Override
    public void setVarchar(Text text, String value) {
        text.set(this.encode((Type)VarcharType.VARCHAR, value));
    }

    private byte[] getFieldValue(String name) {
        return this.columnValues.get(name);
    }

    @Override
    public byte[] encode(Type type, Object value) {
        Object toEncode = Types.isArrayType(type) ? AccumuloRowSerializer.getArrayFromBlock(Types.getElementType(type), (Block)value) : (Types.isMapType(type) ? AccumuloRowSerializer.getMapFromBlock(type, (Block)value) : (type.equals(BigintType.BIGINT) && value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : (type.equals(DateType.DATE) && value instanceof Date ? Long.valueOf(TimeUnit.MILLISECONDS.toDays(((Date)value).getTime())) : (type.equals(IntegerType.INTEGER) && value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : (type.equals(RealType.REAL) && value instanceof Float ? Double.valueOf(((Float)value).doubleValue()) : (type.equals(SmallintType.SMALLINT) && value instanceof Short ? Long.valueOf(((Short)value).longValue()) : (type.equals(TimeType.TIME) && value instanceof Time ? Long.valueOf(((Time)value).getTime()) : (type.equals(TimestampType.TIMESTAMP_MILLIS) && value instanceof Timestamp ? Long.valueOf(((Timestamp)value).getTime()) : (type.equals(TinyintType.TINYINT) && value instanceof Byte ? Long.valueOf(((Byte)value).longValue()) : (type.equals(VarbinaryType.VARBINARY) && value instanceof Slice ? (Object)((Slice)value).getBytes() : (type instanceof VarcharType && value instanceof Slice ? ((Slice)value).toStringUtf8() : value)))))))))));
        return LexicoderRowSerializer.getLexicoder(type).encode(toEncode);
    }

    @Override
    public <T> T decode(Type type, byte[] value) {
        return (T)LexicoderRowSerializer.getLexicoder(type).decode(value);
    }

    public static Lexicoder getLexicoder(Type type) {
        if (Types.isArrayType(type)) {
            return LexicoderRowSerializer.getListLexicoder(type);
        }
        if (Types.isMapType(type)) {
            return LexicoderRowSerializer.getMapLexicoder(type);
        }
        if (type instanceof VarcharType) {
            return LEXICODER_MAP.get(VarcharType.VARCHAR);
        }
        Lexicoder lexicoder = LEXICODER_MAP.get(type);
        if (lexicoder == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "No lexicoder for type " + type);
        }
        return lexicoder;
    }

    private static ListLexicoder getListLexicoder(Type elementType) {
        ListLexicoder listLexicoder = LIST_LEXICODERS.get(elementType);
        if (listLexicoder == null) {
            listLexicoder = new ListLexicoder(LexicoderRowSerializer.getLexicoder(Types.getElementType(elementType)));
            LIST_LEXICODERS.put(elementType, listLexicoder);
        }
        return listLexicoder;
    }

    private static MapLexicoder getMapLexicoder(Type type) {
        MapLexicoder<Object, Object> mapLexicoder = MAP_LEXICODERS.get(type);
        if (mapLexicoder == null) {
            mapLexicoder = new MapLexicoder(LexicoderRowSerializer.getLexicoder(Types.getKeyType(type)), LexicoderRowSerializer.getLexicoder(Types.getValueType(type)));
            MAP_LEXICODERS.put(type, mapLexicoder);
        }
        return mapLexicoder;
    }

    static {
        LongLexicoder longLexicoder = new LongLexicoder();
        DoubleLexicoder doubleLexicoder = new DoubleLexicoder();
        LEXICODER_MAP.put((Type)BigintType.BIGINT, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)BooleanType.BOOLEAN, new BooleanLexicoder());
        LEXICODER_MAP.put((Type)DateType.DATE, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)DoubleType.DOUBLE, (Lexicoder)doubleLexicoder);
        LEXICODER_MAP.put((Type)IntegerType.INTEGER, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)RealType.REAL, (Lexicoder)doubleLexicoder);
        LEXICODER_MAP.put((Type)SmallintType.SMALLINT, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)TimeType.TIME, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)TimestampType.TIMESTAMP_MILLIS, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)TinyintType.TINYINT, (Lexicoder)longLexicoder);
        LEXICODER_MAP.put((Type)VarbinaryType.VARBINARY, (Lexicoder)new BytesLexicoder());
        LEXICODER_MAP.put((Type)VarcharType.VARCHAR, (Lexicoder)new StringLexicoder());
    }
}

