/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.serializers;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.client.lexicoder.impl.ByteUtils;

public class MapLexicoder<K, V>
implements Lexicoder<Map<K, V>> {
    private final Lexicoder<K> keyLexicoder;
    private final Lexicoder<V> valueLexicoder;

    public MapLexicoder(Lexicoder<K> keyLexicoder, Lexicoder<V> valueLexicoder) {
        this.keyLexicoder = keyLexicoder;
        this.valueLexicoder = valueLexicoder;
    }

    public byte[] encode(Map<K, V> v) {
        byte[][] elements = new byte[v.size() * 2][];
        int index = 0;
        for (Map.Entry<K, V> entry : v.entrySet()) {
            elements[index++] = ByteUtils.escape((byte[])this.keyLexicoder.encode(entry.getKey()));
            elements[index++] = ByteUtils.escape((byte[])this.valueLexicoder.encode(entry.getValue()));
        }
        return ByteUtils.concat((byte[][])elements);
    }

    public Map<K, V> decode(byte[] b) {
        byte[][] escapedElements = ByteUtils.split((byte[])b);
        HashMap<Object, Object> decodedMap = new HashMap<Object, Object>();
        for (int i = 0; i < escapedElements.length; i += 2) {
            Object key = this.keyLexicoder.decode(ByteUtils.unescape((byte[])escapedElements[i]));
            Object value = this.valueLexicoder.decode(ByteUtils.unescape((byte[])escapedElements[i + 1]));
            decodedMap.put(key, value);
        }
        return decodedMap;
    }
}

