/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.common.base.Preconditions;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.accumulo.AccumuloMetadata;
import io.trino.plugin.accumulo.AccumuloMetadataFactory;
import io.trino.plugin.accumulo.AccumuloSplitManager;
import io.trino.plugin.accumulo.AccumuloTransactionHandle;
import io.trino.plugin.accumulo.conf.AccumuloSessionProperties;
import io.trino.plugin.accumulo.conf.AccumuloTableProperties;
import io.trino.plugin.accumulo.io.AccumuloPageSinkProvider;
import io.trino.plugin.accumulo.io.AccumuloRecordSetProvider;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class AccumuloConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final AccumuloMetadataFactory metadataFactory;
    private final AccumuloSplitManager splitManager;
    private final AccumuloRecordSetProvider recordSetProvider;
    private final AccumuloPageSinkProvider pageSinkProvider;
    private final AccumuloSessionProperties sessionProperties;
    private final AccumuloTableProperties tableProperties;
    private final ConcurrentMap<ConnectorTransactionHandle, AccumuloMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, AccumuloMetadata>();

    @Inject
    public AccumuloConnector(LifeCycleManager lifeCycleManager, AccumuloMetadataFactory metadataFactory, AccumuloSplitManager splitManager, AccumuloRecordSetProvider recordSetProvider, AccumuloPageSinkProvider pageSinkProvider, AccumuloSessionProperties sessionProperties, AccumuloTableProperties tableProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        this.tableProperties = Objects.requireNonNull(tableProperties, "tableProperties is null");
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        ConnectorMetadata metadata = (ConnectorMetadata)this.transactions.get(transactionHandle);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
        return metadata;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        AccumuloTransactionHandle transaction = new AccumuloTransactionHandle();
        this.transactions.put(transaction, this.metadataFactory.create());
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transactionHandle) {
        Preconditions.checkArgument((this.transactions.remove(transactionHandle) != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
    }

    public void rollback(ConnectorTransactionHandle transactionHandle) {
        AccumuloMetadata metadata = (AccumuloMetadata)this.transactions.remove(transactionHandle);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transactionHandle);
        metadata.rollback();
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties.getTableProperties();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties.getSessionProperties();
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

