/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.io;

import io.trino.plugin.accumulo.AccumuloClient;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.io.AccumuloPageSink;
import io.trino.plugin.accumulo.model.AccumuloTableHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.accumulo.core.client.Connector;

public class AccumuloPageSinkProvider
implements ConnectorPageSinkProvider {
    private final AccumuloClient client;
    private final Connector connector;
    private final String username;

    @Inject
    public AccumuloPageSinkProvider(Connector connector, AccumuloConfig config, AccumuloClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.username = Objects.requireNonNull(config, "config is null").getUsername();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        AccumuloTableHandle tableHandle = (AccumuloTableHandle)outputTableHandle;
        return new AccumuloPageSink(this.connector, this.client.getTable(tableHandle.toSchemaTableName()), this.username);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        return this.createPageSink(transactionHandle, session, (ConnectorOutputTableHandle)insertTableHandle);
    }
}

