/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.predicate.Domain;
import java.util.Objects;
import java.util.Optional;

public class AccumuloColumnConstraint {
    private final String name;
    private final String family;
    private final String qualifier;
    private final boolean indexed;
    private final Optional<Domain> domain;

    @JsonCreator
    public AccumuloColumnConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="family") String family, @JsonProperty(value="qualifier") String qualifier, @JsonProperty(value="domain") Optional<Domain> domain, @JsonProperty(value="indexed") boolean indexed) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.family = Objects.requireNonNull(family, "family is null");
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
        this.indexed = indexed;
        this.domain = Objects.requireNonNull(domain, "domain is null");
    }

    @JsonProperty
    public boolean isIndexed() {
        return this.indexed;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFamily() {
        return this.family;
    }

    @JsonProperty
    public String getQualifier() {
        return this.qualifier;
    }

    @JsonProperty
    public Optional<Domain> getDomain() {
        return this.domain;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.family, this.qualifier, this.domain, this.indexed);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccumuloColumnConstraint other = (AccumuloColumnConstraint)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.family, other.family) && Objects.equals(this.qualifier, other.qualifier) && Objects.equals(this.domain, other.domain) && Objects.equals(this.indexed, other.indexed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("family", (Object)this.family).add("qualifier", (Object)this.qualifier).add("indexed", this.indexed).add("domain", this.domain).toString();
    }
}

