/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class JulAppender
extends AppenderSkeleton {
    protected void append(LoggingEvent loggingEvent) {
        Logger logger = Logger.getLogger(loggingEvent.getLoggerName());
        if (logger == null) {
            LogLog.warn((String)String.format("Cannot obtain JUL %s. Verify that this appender is used while an appropriate LogManager is active.", loggingEvent.getLoggerName()));
            return;
        }
        Level level = loggingEvent.getLevel();
        java.util.logging.Level julLevel = JulAppender.convertLog4jLevel(level);
        LogRecord record = new LogRecord(julLevel, loggingEvent.getRenderedMessage());
        record.setMillis(loggingEvent.getTimeStamp());
        LocationInfo location = loggingEvent.getLocationInformation();
        if (location != null) {
            record.setSourceClassName(location.getClassName());
            record.setSourceMethodName(location.getMethodName());
        }
        logger.log(record);
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }

    private static java.util.logging.Level convertLog4jLevel(Level log4jLevel) {
        if (log4jLevel.equals((Object)Level.TRACE)) {
            return java.util.logging.Level.FINEST;
        }
        if (log4jLevel.equals((Object)Level.DEBUG)) {
            return java.util.logging.Level.FINER;
        }
        if (log4jLevel.equals((Object)Level.INFO)) {
            return java.util.logging.Level.INFO;
        }
        if (log4jLevel.equals((Object)Level.WARN)) {
            return java.util.logging.Level.WARNING;
        }
        if (log4jLevel.equals((Object)Level.ERROR)) {
            return java.util.logging.Level.SEVERE;
        }
        if (log4jLevel.equals((Object)Level.FATAL)) {
            return java.util.logging.Level.SEVERE;
        }
        if (log4jLevel.equals((Object)Level.ALL)) {
            return java.util.logging.Level.ALL;
        }
        if (log4jLevel.equals((Object)Level.OFF)) {
            return java.util.logging.Level.OFF;
        }
        return java.util.logging.Level.FINE;
    }
}

