/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.log.Logger;
import io.trino.plugin.accumulo.AccumuloClient;
import io.trino.plugin.accumulo.AccumuloConnector;
import io.trino.plugin.accumulo.AccumuloErrorCode;
import io.trino.plugin.accumulo.AccumuloHandleResolver;
import io.trino.plugin.accumulo.AccumuloMetadata;
import io.trino.plugin.accumulo.AccumuloMetadataFactory;
import io.trino.plugin.accumulo.AccumuloSplitManager;
import io.trino.plugin.accumulo.AccumuloTableManager;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.conf.AccumuloSessionProperties;
import io.trino.plugin.accumulo.conf.AccumuloTableProperties;
import io.trino.plugin.accumulo.index.ColumnCardinalityCache;
import io.trino.plugin.accumulo.index.IndexLookup;
import io.trino.plugin.accumulo.io.AccumuloPageSinkProvider;
import io.trino.plugin.accumulo.io.AccumuloRecordSetProvider;
import io.trino.plugin.accumulo.metadata.AccumuloTable;
import io.trino.plugin.accumulo.metadata.ZooKeeperMetadataManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.log4j.Appender;
import org.apache.log4j.JulAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class AccumuloModule
implements Module {
    public void configure(Binder binder) {
        JulAppender appender = new JulAppender();
        appender.setLayout((Layout)new PatternLayout("%d %-5p %c - %m%n"));
        appender.setThreshold((Priority)Level.INFO);
        appender.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender((Appender)appender);
        binder.bind(AccumuloConnector.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloClient.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloHandleResolver.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ZooKeeperMetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexLookup.class).in(Scopes.SINGLETON);
        binder.bind(ColumnCardinalityCache.class).in(Scopes.SINGLETON);
        binder.bind(Connector.class).toProvider(ConnectorProvider.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AccumuloConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(AccumuloTable.class));
    }

    private static class ConnectorProvider
    implements Provider<Connector> {
        private static final Logger LOG = Logger.get(ConnectorProvider.class);
        private final String instance;
        private final String zooKeepers;
        private final String username;
        private final String password;

        @Inject
        public ConnectorProvider(AccumuloConfig config) {
            Objects.requireNonNull(config, "config is null");
            this.instance = config.getInstance();
            this.zooKeepers = config.getZooKeepers();
            this.username = config.getUsername();
            this.password = config.getPassword();
        }

        public Connector get() {
            try {
                ZooKeeperInstance inst = new ZooKeeperInstance(this.instance, this.zooKeepers);
                Connector connector = inst.getConnector(this.username, (AuthenticationToken)new PasswordToken(this.password.getBytes(StandardCharsets.UTF_8)));
                LOG.info("Connection to instance %s at %s established, user %s", new Object[]{this.instance, this.zooKeepers, this.username});
                return connector;
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to get connector to Accumulo", e);
            }
        }
    }
}

