/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.accumulo.Types;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Objects;

public class Field {
    private final Object value;
    private final Type type;
    private final boolean indexed;

    public Field(Object nativeValue, Type type) {
        this(nativeValue, type, false);
    }

    public Field(Object nativeValue, Type type, boolean indexed) {
        this.value = Field.convert(nativeValue, type);
        this.type = Objects.requireNonNull(type, "type is null");
        this.indexed = indexed;
    }

    public Field(Field field) {
        this.type = field.type;
        this.indexed = false;
        if (Types.isArrayType(this.type) || Types.isMapType(this.type)) {
            this.value = field.value;
            return;
        }
        if (this.type.equals(BigintType.BIGINT)) {
            this.value = field.getLong();
        } else if (this.type.equals(BooleanType.BOOLEAN)) {
            this.value = field.getBoolean();
        } else if (this.type.equals(DateType.DATE)) {
            this.value = new Date(field.getDate().getTime());
        } else if (this.type.equals(DoubleType.DOUBLE)) {
            this.value = field.getDouble();
        } else if (this.type.equals(IntegerType.INTEGER)) {
            this.value = field.getInt();
        } else if (this.type.equals(RealType.REAL)) {
            this.value = field.getFloat();
        } else if (this.type.equals(SmallintType.SMALLINT)) {
            this.value = field.getShort();
        } else if (this.type.equals(TimeType.TIME)) {
            this.value = new Time(field.getTime().getTime());
        } else if (this.type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            this.value = new Timestamp(field.getTimestamp().getTime());
        } else if (this.type.equals(TinyintType.TINYINT)) {
            this.value = field.getByte();
        } else if (this.type.equals(VarbinaryType.VARBINARY)) {
            this.value = Arrays.copyOf(field.getVarbinary(), field.getVarbinary().length);
        } else if (this.type.equals(VarcharType.VARCHAR)) {
            this.value = field.getVarchar();
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + this.type);
        }
    }

    public Type getType() {
        return this.type;
    }

    public Block getArray() {
        return (Block)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Byte getByte() {
        return (Byte)this.value;
    }

    public Date getDate() {
        return (Date)this.value;
    }

    public Double getDouble() {
        return (Double)this.value;
    }

    public Float getFloat() {
        return (Float)this.value;
    }

    public Integer getInt() {
        return (Integer)this.value;
    }

    public Block getMap() {
        return (Block)this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public Short getShort() {
        return (Short)this.value;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.value;
    }

    public Time getTime() {
        return (Time)this.value;
    }

    public byte[] getVarbinary() {
        return (byte[])this.value;
    }

    public String getVarchar() {
        return (String)this.value;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.indexed);
    }

    public boolean equals(Object obj) {
        Field field;
        boolean retval = true;
        if (obj instanceof Field && this.type.equals((field = (Field)obj).getType())) {
            retval = this.isNull() && field.isNull() ? true : (this.isNull() != field.isNull() ? false : (this.type.equals(VarbinaryType.VARBINARY) ? Arrays.equals((byte[])this.value, (byte[])field.getObject()) : (this.type.equals(DateType.DATE) || this.type.equals(TimeType.TIME) || this.type.equals(TimestampType.TIMESTAMP_MILLIS) ? this.value.toString().equals(field.getObject().toString()) : (this.value instanceof Block ? Field.equals((Block)this.value, (Block)field.getObject()) : this.value.equals(field.getObject())))));
        }
        return retval;
    }

    private static boolean equals(Block block1, Block block2) {
        boolean retval = block1.getPositionCount() == block2.getPositionCount();
        for (int i = 0; i < block1.getPositionCount() && retval; ++i) {
            retval = block1 instanceof ArrayBlock && block2 instanceof ArrayBlock ? Field.equals((Block)block1.getObject(i, Block.class), (Block)block2.getObject(i, Block.class)) : block1.compareTo(i, 0, block1.getSliceLength(i), block2, i, 0, block2.getSliceLength(i)) == 0;
        }
        return retval;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("type", (Object)this.type).toString();
    }

    private static Object convert(Object value, Type type) {
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(value), (String)"Invalid representation for %s: %s [%s]", (Object)type, (Object)value, (Object)value.getClass().getName());
        if (Types.isArrayType(type)) {
            return value;
        }
        if (Types.isMapType(type)) {
            return value;
        }
        if (type.equals(BigintType.BIGINT)) {
            return value;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Math.toIntExact((Long)value);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return value;
        }
        if (type.equals(DateType.DATE)) {
            return Date.valueOf(LocalDate.ofEpochDay((Long)value));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return value;
        }
        if (type.equals(RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return Shorts.checkedCast((long)((Long)value));
        }
        if (type.equals(TimeType.TIME)) {
            return new Time((Long)value);
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return new Timestamp(Math.floorDiv((long)((Long)value), 1000));
        }
        if (type.equals(TinyintType.TINYINT)) {
            return SignedBytes.checkedCast((long)((Long)value));
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return ((Slice)value).getBytes();
        }
        if (type instanceof VarcharType) {
            return ((Slice)value).toStringUtf8();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Trino type: " + type);
    }
}

