/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.util.HostAndPort;

@VisibleForTesting
public class ThriftTransportKey {
    private final HostAndPort server;
    private final long timeout;
    private final SslConnectionParams sslParams;
    private final SaslConnectionParams saslParams;
    private int hash = -1;

    @VisibleForTesting
    public ThriftTransportKey(HostAndPort server, long timeout, ClientContext context) {
        Objects.requireNonNull(server, "location is null");
        this.server = server;
        this.timeout = timeout;
        this.sslParams = context.getClientSslParams();
        this.saslParams = context.getSaslParams();
        if (null != this.saslParams && null != this.sslParams) {
            throw new RuntimeException("Cannot use both SSL and SASL thrift transports");
        }
    }

    ThriftTransportKey(HostAndPort server, long timeout, SslConnectionParams sslParams, SaslConnectionParams saslParams) {
        Objects.requireNonNull(server, "location is null");
        this.server = server;
        this.timeout = timeout;
        this.sslParams = sslParams;
        this.saslParams = saslParams;
    }

    HostAndPort getServer() {
        return this.server;
    }

    long getTimeout() {
        return this.timeout;
    }

    public boolean isSsl() {
        return this.sslParams != null;
    }

    public boolean isSasl() {
        return this.saslParams != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThriftTransportKey)) {
            return false;
        }
        ThriftTransportKey ttk = (ThriftTransportKey)o;
        return this.server.equals(ttk.server) && this.timeout == ttk.timeout && (!this.isSsl() || ttk.isSsl() && this.sslParams.equals(ttk.sslParams)) && (!this.isSasl() || ttk.isSasl() && this.saslParams.equals(ttk.saslParams));
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        String prefix = "";
        if (this.isSsl()) {
            prefix = "ssl:";
        } else if (this.isSasl()) {
            prefix = this.saslParams.toString() + ":";
        }
        return prefix + this.server + " (" + Long.toString(this.timeout) + ")";
    }

    public SslConnectionParams getSslParams() {
        return this.sslParams;
    }

    public SaslConnectionParams getSaslParams() {
        return this.saslParams;
    }
}

