/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.PathUtility;
import java.net.URI;
import java.net.URISyntaxException;

public final class StorageCredentialsSharedAccessSignature
extends StorageCredentials {
    private final String token;

    public StorageCredentialsSharedAccessSignature(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s", "SharedAccessSignature", exportSecrets ? this.token : "[signature hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) throws URISyntaxException, StorageException {
        if (resourceUri == null) {
            return null;
        }
        URI sasUri = PathUtility.addToQuery(resourceUri, this.token);
        String apiVersion = "api-version=2014-02-14";
        return PathUtility.addToQuery(sasUri, apiVersion);
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) throws URISyntaxException, StorageException {
        return new StorageUri(this.transformUri(resourceUri.getPrimaryUri(), opContext), this.transformUri(resourceUri.getSecondaryUri(), opContext));
    }
}

