/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentialsAccountAndKey;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageKey;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.BaseRequest;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;

public class StorageCredentialsHelper {
    public static boolean canCredentialsSignRequest(StorageCredentials creds) {
        return creds.getClass().equals(StorageCredentialsAccountAndKey.class);
    }

    @Deprecated
    public static boolean canCredentialsSignRequestLite(StorageCredentials creds) {
        return creds.getClass().equals(StorageCredentialsAccountAndKey.class);
    }

    public static String computeHmac256(StorageCredentials creds, String value) throws InvalidKeyException {
        return StorageCredentialsHelper.computeHmac256(creds, value, null);
    }

    public static String computeHmac256(StorageCredentials creds, String value, OperationContext opContext) throws InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            return StorageKey.computeMacSha256(((StorageCredentialsAccountAndKey)creds).getCredentials().getKey(), value);
        }
        return null;
    }

    public static void signBlobAndQueueRequest(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signBlobAndQueueRequest(creds, request, contentLength, null);
    }

    public static void signBlobAndQueueRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForBlobAndQueue(request, ((StorageCredentialsAccountAndKey)creds).getCredentials(), contentLength, opContext);
        }
    }

    @Deprecated
    public static void signBlobAndQueueRequestLite(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signBlobAndQueueRequestLite(creds, request, contentLength, null);
    }

    @Deprecated
    public static void signBlobAndQueueRequestLite(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws StorageException, InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForBlobAndQueueSharedKeyLite(request, ((StorageCredentialsAccountAndKey)creds).getCredentials(), contentLength, opContext);
        }
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signTableRequest(creds, request, contentLength, null);
    }

    public static void signTableRequest(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForTableSharedKey(request, ((StorageCredentialsAccountAndKey)creds).getCredentials(), contentLength, opContext);
        }
    }

    @Deprecated
    public static void signTableRequestLite(StorageCredentials creds, HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        StorageCredentialsHelper.signTableRequestLite(creds, request, contentLength, null);
    }

    @Deprecated
    public static void signTableRequestLite(StorageCredentials creds, HttpURLConnection request, long contentLength, OperationContext opContext) throws StorageException, InvalidKeyException {
        if (creds.getClass().equals(StorageCredentialsAccountAndKey.class)) {
            opContext = opContext == null ? new OperationContext() : opContext;
            BaseRequest.signRequestForTableSharedKeyLite(request, ((StorageCredentialsAccountAndKey)creds).getCredentials(), contentLength, opContext);
        }
    }
}

