/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.tools.GetGroupsBase;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class GetGroups
extends GetGroupsBase {
    private static final Log LOG = LogFactory.getLog(GetGroups.class);
    static final String USAGE = "Usage: hdfs groups [username ...]";

    public GetGroups(Configuration conf) {
        super(conf);
    }

    public GetGroups(Configuration conf, PrintStream out) {
        super(conf, out);
    }

    @Override
    protected InetSocketAddress getProtocolAddress(Configuration conf) throws IOException {
        return NameNode.getAddress(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        conf = new HdfsConfiguration(conf);
        String nameNodePrincipal = conf.get("dfs.namenode.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using NN principal: " + nameNodePrincipal);
        }
        conf.set("hadoop.security.service.user.name.key", nameNodePrincipal);
        super.setConf(conf);
    }

    @Override
    protected GetUserMappingsProtocol getUgmProtocol() throws IOException {
        return NameNodeProxies.createProxy(this.getConf(), FileSystem.getDefaultUri(this.getConf()), GetUserMappingsProtocol.class).getProxy();
    }

    public static void main(String[] argv) throws Exception {
        if (DFSUtil.parseHelpArgument(argv, USAGE, System.out, true)) {
            System.exit(0);
        }
        int res = ToolRunner.run(new GetGroups(new HdfsConfiguration()), argv);
        System.exit(res);
    }

    static {
        HdfsConfiguration.init();
    }
}

