/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class DataDrivenDBRecordReader<T extends DBWritable>
extends DBRecordReader<T> {
    private static final Log LOG = LogFactory.getLog(DataDrivenDBRecordReader.class);
    private String dbProductName;

    public DataDrivenDBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table, String dbProduct) throws SQLException {
        super(split, inputClass, conf, conn, dbConfig, cond, fields, table);
        this.dbProductName = dbProduct;
    }

    @Override
    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        DataDrivenDBInputFormat.DataDrivenDBInputSplit dataSplit = (DataDrivenDBInputFormat.DataDrivenDBInputSplit)this.getSplit();
        DBConfiguration dbConf = this.getDBConf();
        String[] fieldNames = this.getFieldNames();
        String tableName = this.getTableName();
        String conditions = this.getConditions();
        StringBuilder conditionClauses = new StringBuilder();
        conditionClauses.append("( ").append(dataSplit.getLowerClause());
        conditionClauses.append(" ) AND ( ").append(dataSplit.getUpperClause());
        conditionClauses.append(" )");
        if (dbConf.getInputQuery() == null) {
            query.append("SELECT ");
            for (int i = 0; i < fieldNames.length; ++i) {
                query.append(fieldNames[i]);
                if (i == fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(tableName);
            if (!this.dbProductName.startsWith("ORACLE")) {
                query.append(" AS ").append(tableName);
            }
            query.append(" WHERE ");
            if (conditions != null && conditions.length() > 0) {
                query.append("( ").append(conditions).append(" ) AND ");
            }
            query.append(conditionClauses.toString());
        } else {
            String inputQuery = dbConf.getInputQuery();
            if (inputQuery.indexOf("$CONDITIONS") == -1) {
                LOG.error("Could not find the clause substitution token $CONDITIONS in the query: [" + inputQuery + "]. Parallel splits may not work correctly.");
            }
            query.append(inputQuery.replace("$CONDITIONS", conditionClauses.toString()));
        }
        LOG.debug("Using query: " + query.toString());
        return query.toString();
    }
}

