/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.configuration;

import io.prestosql.hadoop.$internal.org.apache.commons.configuration.Configuration;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigurationMap
extends AbstractMap {
    private Configuration configuration;

    public ConfigurationMap(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set entrySet() {
        return new ConfigurationSet(this.configuration);
    }

    public Object put(Object key, Object value) {
        String strKey = String.valueOf(key);
        Object old = this.configuration.getProperty(strKey);
        this.configuration.setProperty(strKey, value);
        return old;
    }

    public Object get(Object key) {
        return this.configuration.getProperty(String.valueOf(key));
    }

    static class ConfigurationSet
    extends AbstractSet {
        private Configuration configuration;

        ConfigurationSet(Configuration configuration) {
            this.configuration = configuration;
        }

        public int size() {
            int count = 0;
            Iterator iterator = this.configuration.getKeys();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }

        public Iterator iterator() {
            return new ConfigurationSetIterator();
        }

        private final class ConfigurationSetIterator
        implements Iterator {
            private Iterator keys;

            private ConfigurationSetIterator() {
                this.keys = ConfigurationSet.this.configuration.getKeys();
            }

            public boolean hasNext() {
                return this.keys.hasNext();
            }

            public Object next() {
                return new Entry(this.keys.next());
            }

            public void remove() {
                this.keys.remove();
            }
        }

        private final class Entry
        implements Map.Entry {
            private Object key;

            private Entry(Object key) {
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return ConfigurationSet.this.configuration.getProperty((String)this.key);
            }

            public Object setValue(Object value) {
                Object old = this.getValue();
                ConfigurationSet.this.configuration.setProperty((String)this.key, value);
                return old;
            }
        }
    }
}

