/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.http.impl.client;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.http.Header;
import io.prestosql.hadoop.$internal.org.apache.http.HttpEntity;
import io.prestosql.hadoop.$internal.org.apache.http.HttpEntityEnclosingRequest;
import io.prestosql.hadoop.$internal.org.apache.http.ProtocolException;
import io.prestosql.hadoop.$internal.org.apache.http.entity.HttpEntityWrapper;
import io.prestosql.hadoop.$internal.org.apache.http.impl.client.RequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@.NotThreadSafe
public class EntityEnclosingRequestWrapper
extends RequestWrapper
implements HttpEntityEnclosingRequest {
    private HttpEntity entity;
    private boolean consumed;

    public EntityEnclosingRequestWrapper(HttpEntityEnclosingRequest request) throws ProtocolException {
        super(request);
        this.setEntity(request.getEntity());
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity != null ? new EntityWrapper(entity) : null;
        this.consumed = false;
    }

    public boolean expectContinue() {
        Header expect = this.getFirstHeader("Expect");
        return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
    }

    public boolean isRepeatable() {
        return this.entity == null || this.entity.isRepeatable() || !this.consumed;
    }

    class EntityWrapper
    extends HttpEntityWrapper {
        EntityWrapper(HttpEntity entity) {
            super(entity);
        }

        public void consumeContent() throws IOException {
            EntityEnclosingRequestWrapper.this.consumed = true;
            super.consumeContent();
        }

        public InputStream getContent() throws IOException {
            EntityEnclosingRequestWrapper.this.consumed = true;
            return super.getContent();
        }

        public void writeTo(OutputStream outstream) throws IOException {
            EntityEnclosingRequestWrapper.this.consumed = true;
            super.writeTo(outstream);
        }
    }
}

