/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.CallbackHandler;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.SaslClientDigestCallbackHandler;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslConnectionParams {
    private static final Logger log = LoggerFactory.getLogger(SaslConnectionParams.class);
    private static String defaultRealm;
    protected String principal;
    protected QualityOfProtection qop;
    protected String kerberosServerPrimary;
    protected SaslMechanism mechanism;
    protected CallbackHandler callbackHandler;
    protected final Map<String, String> saslProperties;

    public SaslConnectionParams(AccumuloConfiguration conf, AuthenticationToken token) {
        this(new ClientConfiguration(new Configuration[]{SaslConnectionParams.createMapConfiguration(conf)}), token);
    }

    private static MapConfiguration createMapConfiguration(AccumuloConfiguration conf) {
        MapConfiguration mapConf = new MapConfiguration(SaslConnectionParams.getProperties(conf));
        mapConf.setListDelimiter('\u0000');
        return mapConf;
    }

    public SaslConnectionParams(ClientConfiguration conf, AuthenticationToken token) {
        Objects.requireNonNull(conf, "Configuration was null");
        Objects.requireNonNull(token, "AuthenticationToken was null");
        this.saslProperties = new HashMap<String, String>();
        this.updatePrincipalFromUgi();
        this.updateFromConfiguration(conf);
        this.updateFromToken(token);
    }

    protected void updateFromToken(AuthenticationToken token) {
        if (token instanceof KerberosToken) {
            this.mechanism = SaslMechanism.GSSAPI;
            this.callbackHandler = null;
        } else if (token instanceof DelegationTokenImpl) {
            this.mechanism = SaslMechanism.DIGEST_MD5;
            this.callbackHandler = new SaslClientDigestCallbackHandler((DelegationTokenImpl)token);
        } else {
            throw new IllegalArgumentException("Cannot determine SASL mechanism for token class: " + token.getClass());
        }
    }

    protected static Map<String, String> getProperties(AccumuloConfiguration conf) {
        HashMap<String, String> clientProperties = new HashMap<String, String>();
        String serverPrincipal = conf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
        try {
            KerberosName krbName = new KerberosName(serverPrincipal);
            clientProperties.put(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY.getKey(), krbName.getServiceName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> clientKeys = new HashSet<String>();
        for (ClientConfiguration.ClientProperty prop : ClientConfiguration.ClientProperty.values()) {
            clientKeys.add(prop.getKey());
        }
        for (Map.Entry<String, String> entry : conf) {
            String key = entry.getKey();
            if (!clientKeys.contains(key)) continue;
            clientProperties.put(key, entry.getValue());
        }
        return clientProperties;
    }

    protected void updatePrincipalFromUgi() {
        UserGroupInformation currentUser;
        if (!UserGroupInformation.isSecurityEnabled()) {
            throw new RuntimeException("Cannot use SASL if Hadoop security is not enabled");
        }
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get current user", e);
        }
        this.principal = currentUser.getUserName();
        if (null == this.principal) {
            throw new RuntimeException("Got null username from " + currentUser);
        }
    }

    protected void updateFromConfiguration(ClientConfiguration conf) {
        String qopValue = conf.get(ClientConfiguration.ClientProperty.RPC_SASL_QOP);
        this.qop = QualityOfProtection.get(qopValue);
        this.saslProperties.put("javax.security.sasl.qop", this.qop.getQuality());
        this.kerberosServerPrimary = conf.get(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY);
    }

    public Map<String, String> getSaslProperties() {
        return Collections.unmodifiableMap(this.saslProperties);
    }

    public QualityOfProtection getQualityOfProtection() {
        return this.qop;
    }

    public String getKerberosServerPrimary() {
        return this.kerberosServerPrimary;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public SaslMechanism getMechanism() {
        return this.mechanism;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(23, 29);
        hcb.append((Object)this.kerberosServerPrimary).append(this.saslProperties).append(this.qop.hashCode()).append((Object)this.principal).append((Object)this.mechanism).append((Object)this.callbackHandler);
        return hcb.toHashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SaslConnectionParams) {
            SaslConnectionParams other = (SaslConnectionParams)o;
            if (!this.kerberosServerPrimary.equals(other.kerberosServerPrimary)) {
                return false;
            }
            if (this.qop != other.qop) {
                return false;
            }
            if (!this.principal.equals(other.principal)) {
                return false;
            }
            if (!this.mechanism.equals((Object)other.mechanism)) {
                return false;
            }
            if (null == this.callbackHandler ? null != other.callbackHandler : !this.callbackHandler.equals(other.callbackHandler)) {
                return false;
            }
            return this.saslProperties.equals(other.saslProperties);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("SaslConnectionParams[").append("kerberosServerPrimary=").append(this.kerberosServerPrimary).append(", qualityOfProtection=").append((Object)this.qop);
        sb.append(", principal=").append(this.principal).append(", mechanism=").append((Object)this.mechanism).append(", callbackHandler=").append(this.callbackHandler).append("]");
        return sb.toString();
    }

    public static String getDefaultRealm() {
        return defaultRealm;
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            log.debug("Kerberos krb5 configuration not found, setting default realm to empty");
            defaultRealm = "UNKNOWN";
        }
    }

    public static enum SaslMechanism {
        GSSAPI("GSSAPI"),
        DIGEST_MD5("DIGEST-MD5");

        private final String mechanismName;

        private SaslMechanism(String mechanismName) {
            this.mechanismName = mechanismName;
        }

        public String getMechanismName() {
            return this.mechanismName;
        }

        public static SaslMechanism get(String mechanismName) {
            if (SaslMechanism.GSSAPI.mechanismName.equals(mechanismName)) {
                return GSSAPI;
            }
            if (SaslMechanism.DIGEST_MD5.mechanismName.equals(mechanismName)) {
                return DIGEST_MD5;
            }
            throw new IllegalArgumentException("No value for " + mechanismName);
        }
    }

    public static enum QualityOfProtection {
        AUTH("auth"),
        AUTH_INT("auth-int"),
        AUTH_CONF("auth-conf");

        private final String quality;

        private QualityOfProtection(String quality) {
            this.quality = quality;
        }

        public String getQuality() {
            return this.quality;
        }

        public static QualityOfProtection get(String name) {
            if (QualityOfProtection.AUTH.quality.equals(name)) {
                return AUTH;
            }
            if (QualityOfProtection.AUTH_INT.quality.equals(name)) {
                return AUTH_INT;
            }
            if (QualityOfProtection.AUTH_CONF.quality.equals(name)) {
                return AUTH_CONF;
            }
            throw new IllegalArgumentException("No value for " + name);
        }

        public String toString() {
            return this.quality;
        }
    }
}

