/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.AbstractMap;
import java.util.Map;

public class Pair<A, B> {
    A first;
    B second;

    public Pair(A f, B s) {
        this.first = f;
        this.second = s;
    }

    private int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public int hashCode() {
        return this.hashCode(this.first) + this.hashCode(this.second);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair op = (Pair)o;
            return this.equals(this.first, op.first) && this.equals(this.second, op.second);
        }
        return false;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return this.toString("(", ",", ")");
    }

    public String toString(String prefix, String separator, String suffix) {
        return prefix + this.first + separator + this.second + suffix;
    }

    public Map.Entry<A, B> toMapEntry() {
        return new AbstractMap.SimpleImmutableEntry<A, B>(this.getFirst(), this.getSecond());
    }

    public Pair<B, A> swap() {
        return new Pair<B, A>(this.getSecond(), this.getFirst());
    }

    public static <K2, V2, K1 extends K2, V1 extends V2> Pair<K2, V2> fromEntry(Map.Entry<K1, V1> entry) {
        return new Pair<K1, V1>(entry.getKey(), entry.getValue());
    }
}

