/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.accumulo.AccumuloClient;
import io.trino.plugin.accumulo.model.AccumuloColumnConstraint;
import io.trino.plugin.accumulo.model.AccumuloColumnHandle;
import io.trino.plugin.accumulo.model.AccumuloSplit;
import io.trino.plugin.accumulo.model.AccumuloTableHandle;
import io.trino.plugin.accumulo.model.SerializedRange;
import io.trino.plugin.accumulo.model.TabletSplitMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AccumuloSplitManager
implements ConnectorSplitManager {
    private final AccumuloClient client;

    @Inject
    public AccumuloSplitManager(AccumuloClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        AccumuloTableHandle handle = (AccumuloTableHandle)tableHandle;
        String schemaName = handle.getSchema();
        String tableName = handle.getTable();
        String rowIdName = handle.getRowId();
        List<AccumuloColumnConstraint> constraints = AccumuloSplitManager.getColumnConstraints(rowIdName, handle.getConstraint());
        Optional<Domain> rDom = AccumuloSplitManager.getRangeDomain(rowIdName, handle.getConstraint());
        List<TabletSplitMetadata> tabletSplits = this.client.getTabletSplits(session, schemaName, tableName, rDom, constraints, handle.getSerializerInstance());
        ImmutableList.Builder cSplits = ImmutableList.builder();
        for (TabletSplitMetadata splitMetadata : tabletSplits) {
            AccumuloSplit split = new AccumuloSplit(splitMetadata.getRanges().stream().map(SerializedRange::serialize).collect(Collectors.toList()), splitMetadata.getHostPort());
            cSplits.add((Object)split);
        }
        return new FixedSplitSource((Iterable)cSplits.build());
    }

    private static Optional<Domain> getRangeDomain(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        if (constraint.getColumnDomains().isPresent()) {
            for (TupleDomain.ColumnDomain cd : (List)constraint.getColumnDomains().get()) {
                AccumuloColumnHandle col = (AccumuloColumnHandle)cd.getColumn();
                if (!col.getName().equals(rowIdName)) continue;
                return Optional.of(cd.getDomain());
            }
        }
        return Optional.empty();
    }

    private static List<AccumuloColumnConstraint> getColumnConstraints(String rowIdName, TupleDomain<ColumnHandle> constraint) {
        ImmutableList.Builder constraintBuilder = ImmutableList.builder();
        for (TupleDomain.ColumnDomain columnDomain : (List)constraint.getColumnDomains().get()) {
            AccumuloColumnHandle columnHandle = (AccumuloColumnHandle)columnDomain.getColumn();
            if (columnHandle.getName().equals(rowIdName)) continue;
            constraintBuilder.add((Object)new AccumuloColumnConstraint(columnHandle.getName(), columnHandle.getFamily().get(), columnHandle.getQualifier().get(), Optional.of(columnDomain.getDomain()), columnHandle.isIndexed()));
        }
        return constraintBuilder.build();
    }
}

