/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.log.Logger;
import io.trino.plugin.accumulo.AccumuloConnector;
import io.trino.plugin.accumulo.AccumuloMetadata;
import io.trino.plugin.accumulo.AccumuloMetadataFactory;
import io.trino.plugin.accumulo.AccumuloMetadataManager;
import io.trino.plugin.accumulo.AccumuloSplitManager;
import io.trino.plugin.accumulo.AccumuloTableManager;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.conf.AccumuloSessionProperties;
import io.trino.plugin.accumulo.conf.AccumuloTableProperties;
import io.trino.plugin.accumulo.index.ColumnCardinalityCache;
import io.trino.plugin.accumulo.index.IndexLookup;
import io.trino.plugin.accumulo.io.AccumuloPageSinkProvider;
import io.trino.plugin.accumulo.io.AccumuloRecordSetProvider;
import io.trino.plugin.accumulo.metadata.AccumuloTable;
import io.trino.plugin.accumulo.metadata.ZooKeeperMetadataManager;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;

public class AccumuloModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(AccumuloConnector.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloMetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ZooKeeperMetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloTableManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexLookup.class).in(Scopes.SINGLETON);
        binder.bind(ColumnCardinalityCache.class).in(Scopes.SINGLETON);
        binder.bind(AccumuloClient.class).toProvider(ClientProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(AccumuloConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, JsonCodec.listJsonCodec(AccumuloTable.class));
    }

    private static class ClientProvider
    implements Provider<AccumuloClient> {
        private static final Logger LOG = Logger.get(ClientProvider.class);
        private final String instance;
        private final String zooKeepers;
        private final String username;
        private final String password;

        @Inject
        public ClientProvider(AccumuloConfig config) {
            this.instance = config.getInstance();
            this.zooKeepers = config.getZooKeepers();
            this.username = config.getUsername();
            this.password = config.getPassword();
        }

        public AccumuloClient get() {
            AccumuloClient client = (AccumuloClient)Accumulo.newClient().to((CharSequence)this.instance, (CharSequence)this.zooKeepers).as((CharSequence)this.username, (CharSequence)this.password).build();
            LOG.info("Connection to instance %s at %s established, user %s", new Object[]{this.instance, this.zooKeepers, this.username});
            return client;
        }
    }
}

