/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.trino.plugin.accumulo.Types;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;

public class Field {
    private final Object value;
    private final Type type;
    private final boolean indexed;

    public Field(Object nativeValue, Type type) {
        this(nativeValue, type, false);
    }

    public Field(Object nativeValue, Type type, boolean indexed) {
        this.value = Field.convert(nativeValue, type);
        this.type = Objects.requireNonNull(type, "type is null");
        this.indexed = indexed;
    }

    public Type getType() {
        return this.type;
    }

    public Block getArray() {
        return (Block)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Byte getByte() {
        return (Byte)this.value;
    }

    public long getDate() {
        return (Long)this.value;
    }

    public Double getDouble() {
        return (Double)this.value;
    }

    public Float getFloat() {
        return (Float)this.value;
    }

    public Integer getInt() {
        return (Integer)this.value;
    }

    public SqlMap getMap() {
        return (SqlMap)this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public Short getShort() {
        return (Short)this.value;
    }

    public Timestamp getTimestamp() {
        return (Timestamp)this.value;
    }

    public Time getTime() {
        return (Time)this.value;
    }

    public byte[] getVarbinary() {
        return (byte[])this.value;
    }

    public String getVarchar() {
        return (String)this.value;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("type", (Object)this.type).toString();
    }

    private static Object convert(Object value, Type type) {
        if (value == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(value), (String)"Invalid representation for %s: %s [%s]", (Object)type, (Object)value, (Object)value.getClass().getName());
        if (Types.isArrayType(type)) {
            return value;
        }
        if (Types.isMapType(type)) {
            return value;
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return value;
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return Math.toIntExact((Long)value);
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return value;
        }
        if (type.equals((Object)DateType.DATE)) {
            return value;
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return value;
        }
        if (type.equals((Object)RealType.REAL)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return Shorts.checkedCast((long)((Long)value));
        }
        if (type.equals((Object)TimeType.TIME_MILLIS)) {
            return new Time((Long)value);
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            return new Timestamp(Math.floorDiv((long)((Long)value), 1000));
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return SignedBytes.checkedCast((long)((Long)value));
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return ((Slice)value).getBytes();
        }
        if (type instanceof VarcharType) {
            return ((Slice)value).toStringUtf8();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported Trino type: " + String.valueOf(type));
    }
}

