/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.serializers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.airlift.slice.Slice;
import io.trino.plugin.accumulo.Types;
import io.trino.plugin.accumulo.io.AccumuloPageSink;
import io.trino.plugin.accumulo.serializers.AccumuloRowSerializer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;

public class StringRowSerializer
implements AccumuloRowSerializer {
    private final Table<String, String, String> familyQualifierColumnMap = HashBasedTable.create();
    private final Map<String, Object> columnValues = new HashMap<String, Object>();
    private final Text rowId = new Text();
    private final Text family = new Text();
    private final Text qualifier = new Text();
    private final Text value = new Text();
    private boolean rowOnly;
    private String rowIdName;

    @Override
    public void setRowIdName(String name) {
        this.rowIdName = name;
    }

    @Override
    public void setRowOnly(boolean rowOnly) {
        this.rowOnly = rowOnly;
    }

    @Override
    public void setMapping(String name, String family, String qualifier) {
        this.columnValues.put(name, null);
        this.familyQualifierColumnMap.put((Object)family, (Object)qualifier, (Object)name);
    }

    @Override
    public void reset() {
        this.columnValues.clear();
    }

    @Override
    public void deserialize(Map.Entry<Key, Value> entry) {
        if (!this.columnValues.containsKey(this.rowIdName)) {
            entry.getKey().getRow(this.rowId);
            this.columnValues.put(this.rowIdName, this.rowId.toString());
        }
        if (this.rowOnly) {
            return;
        }
        entry.getKey().getColumnFamily(this.family);
        entry.getKey().getColumnQualifier(this.qualifier);
        if (this.family.equals((Object)AccumuloPageSink.ROW_ID_COLUMN) && this.qualifier.equals((Object)AccumuloPageSink.ROW_ID_COLUMN)) {
            return;
        }
        this.value.set(entry.getValue().get());
        this.columnValues.put((String)this.familyQualifierColumnMap.get((Object)this.family.toString(), (Object)this.qualifier.toString()), this.value.toString());
    }

    @Override
    public boolean isNull(String name) {
        return this.columnValues.get(name) == null;
    }

    @Override
    public Block getArray(String name, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public void setArray(Text text, Type type, Block block) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getFieldValue(name));
    }

    @Override
    public void setBoolean(Text text, Boolean value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte getByte(String name) {
        return Byte.parseByte(this.getFieldValue(name));
    }

    @Override
    public void setByte(Text text, Byte value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long getDate(String name) {
        return Long.parseLong(this.getFieldValue(name));
    }

    @Override
    public void setDate(Text text, long value) {
        text.set(Long.toString(value).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public double getDouble(String name) {
        return Double.parseDouble(this.getFieldValue(name));
    }

    @Override
    public void setDouble(Text text, Double value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public float getFloat(String name) {
        return Float.parseFloat(this.getFieldValue(name));
    }

    @Override
    public void setFloat(Text text, Float value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int getInt(String name) {
        return Integer.parseInt(this.getFieldValue(name));
    }

    @Override
    public void setInt(Text text, Integer value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public long getLong(String name) {
        return Long.parseLong(this.getFieldValue(name));
    }

    @Override
    public void setLong(Text text, Long value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public SqlMap getMap(String name, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public void setMap(Text text, Type type, SqlMap map) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
    }

    @Override
    public short getShort(String name) {
        return Short.parseShort(this.getFieldValue(name));
    }

    @Override
    public void setShort(Text text, Short value) {
        text.set(value.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Time getTime(String name) {
        return new Time(Long.parseLong(this.getFieldValue(name)));
    }

    @Override
    public void setTime(Text text, Time value) {
        text.set(Long.toString(value.getTime()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Timestamp getTimestamp(String name) {
        return new Timestamp(Long.parseLong(this.getFieldValue(name)));
    }

    @Override
    public void setTimestamp(Text text, Timestamp value) {
        text.set(Long.toString(value.getTime()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] getVarbinary(String name) {
        return this.getFieldValue(name).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void setVarbinary(Text text, byte[] value) {
        text.set(value);
    }

    @Override
    public String getVarchar(String name) {
        return this.getFieldValue(name);
    }

    @Override
    public void setVarchar(Text text, String value) {
        text.set(value.getBytes(StandardCharsets.UTF_8));
    }

    private String getFieldValue(String name) {
        return this.columnValues.get(name).toString();
    }

    @Override
    public byte[] encode(Type type, Object value) {
        Text text = new Text();
        if (Types.isArrayType(type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "arrays are not (yet?) supported for StringRowSerializer");
        }
        if (Types.isMapType(type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "maps are not (yet?) supported for StringRowSerializer");
        }
        if (type.equals((Object)BigintType.BIGINT) && value instanceof Integer) {
            this.setLong(text, ((Integer)value).longValue());
        } else if (type.equals((Object)BigintType.BIGINT) && value instanceof Long) {
            this.setLong(text, (Long)value);
        } else if (type.equals((Object)BooleanType.BOOLEAN)) {
            this.setBoolean(text, value.equals(Boolean.TRUE));
        } else if (type.equals((Object)DateType.DATE)) {
            this.setDate(text, (Long)value);
        } else if (type.equals((Object)DoubleType.DOUBLE)) {
            this.setDouble(text, (Double)value);
        } else if (type.equals((Object)IntegerType.INTEGER) && value instanceof Integer) {
            this.setInt(text, (Integer)value);
        } else if (type.equals((Object)IntegerType.INTEGER) && value instanceof Long) {
            this.setInt(text, ((Long)value).intValue());
        } else if (type.equals((Object)RealType.REAL)) {
            this.setFloat(text, (Float)value);
        } else if (type.equals((Object)SmallintType.SMALLINT)) {
            this.setShort(text, (Short)value);
        } else if (type.equals((Object)TimeType.TIME_MILLIS)) {
            this.setTime(text, (Time)value);
        } else if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            this.setTimestamp(text, (Timestamp)value);
        } else if (type.equals((Object)TinyintType.TINYINT)) {
            this.setByte(text, (Byte)value);
        } else if (type.equals((Object)VarbinaryType.VARBINARY) && value instanceof byte[]) {
            this.setVarbinary(text, (byte[])value);
        } else if (type.equals((Object)VarbinaryType.VARBINARY) && value instanceof Slice) {
            this.setVarbinary(text, ((Slice)value).getBytes());
        } else if (type.equals((Object)VarcharType.VARCHAR) && value instanceof String) {
            this.setVarchar(text, (String)value);
        } else if (type.equals((Object)VarcharType.VARCHAR) && value instanceof Slice) {
            this.setVarchar(text, ((Slice)value).toStringUtf8());
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("StringLexicoder does not support encoding type %s, object class is %s", type, value.getClass()));
        }
        return text.copyBytes();
    }

    @Override
    public <T> T decode(Type type, byte[] value) {
        String strValue = new String(value, StandardCharsets.UTF_8);
        if (type.equals((Object)BigintType.BIGINT)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(strValue));
        }
        if (type.equals((Object)DateType.DATE)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return (T)Double.valueOf(Double.parseDouble(strValue));
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return (T)Long.valueOf(Integer.valueOf(Integer.parseInt(strValue)).longValue());
        }
        if (type.equals((Object)RealType.REAL)) {
            return (T)Double.valueOf(Float.valueOf(Float.parseFloat(strValue)).doubleValue());
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return (T)Long.valueOf(Short.valueOf(Short.parseShort(strValue)).longValue());
        }
        if (type.equals((Object)TimeType.TIME_MILLIS)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
            return (T)Long.valueOf(Long.parseLong(strValue));
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return (T)Long.valueOf(Byte.valueOf(Byte.parseByte(strValue)).longValue());
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return (T)value;
        }
        if (type.equals((Object)VarcharType.VARCHAR)) {
            return (T)strValue;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type " + String.valueOf(type));
    }
}

