/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.SendingRequestEvent;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageEvent;
import io.trino.hadoop.$internal.org.apache.commons.logging.Log;
import io.trino.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class SendRequestIntercept
extends StorageEvent<SendingRequestEvent> {
    public static final Log LOG = LogFactory.getLog(SendRequestIntercept.class);
    private static final String ALLOW_ALL_REQUEST_PRECONDITIONS = "*";

    private SendRequestIntercept() {
    }

    public static void bind(OperationContext opContext) {
        opContext.getSendingRequestEventHandler().addListener(new SendRequestIntercept());
    }

    @Override
    public void eventOccurred(SendingRequestEvent sendEvent) {
        if (!(sendEvent.getConnectionObject() instanceof HttpURLConnection)) {
            return;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)sendEvent.getConnectionObject();
        if (urlConnection.getRequestMethod().equalsIgnoreCase("GET")) {
            urlConnection.setRequestProperty("If-Match", ALLOW_ALL_REQUEST_PRECONDITIONS);
        }
    }
}

