/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIOException;

public class ReplicaInputStreams
implements Closeable {
    public static final Logger LOG = DataNode.LOG;
    private InputStream dataIn;
    private InputStream checksumIn;
    private FsVolumeReference volumeRef;
    private final FileIoProvider fileIoProvider;
    private FileDescriptor dataInFd = null;

    public ReplicaInputStreams(InputStream dataStream, InputStream checksumStream, FsVolumeReference volumeRef, FileIoProvider fileIoProvider) {
        this.volumeRef = volumeRef;
        this.fileIoProvider = fileIoProvider;
        this.dataIn = dataStream;
        this.checksumIn = checksumStream;
        if (this.dataIn instanceof FileInputStream) {
            try {
                this.dataInFd = ((FileInputStream)this.dataIn).getFD();
            }
            catch (Exception e) {
                LOG.warn("Could not get file descriptor for inputstream of class " + this.dataIn.getClass());
            }
        } else {
            LOG.debug("Could not get file descriptor for inputstream of class " + this.dataIn.getClass());
        }
    }

    public InputStream getDataIn() {
        return this.dataIn;
    }

    public InputStream getChecksumIn() {
        return this.checksumIn;
    }

    public FileDescriptor getDataInFd() {
        return this.dataInFd;
    }

    public FsVolumeReference getVolumeRef() {
        return this.volumeRef;
    }

    public void readDataFully(byte[] buf, int off, int len) throws IOException {
        IOUtils.readFully(this.dataIn, buf, off, len);
    }

    public void readChecksumFully(byte[] buf, int off, int len) throws IOException {
        IOUtils.readFully(this.checksumIn, buf, off, len);
    }

    public void skipDataFully(long len) throws IOException {
        IOUtils.skipFully(this.dataIn, len);
    }

    public void skipChecksumFully(long len) throws IOException {
        IOUtils.skipFully(this.checksumIn, len);
    }

    public void closeChecksumStream() throws IOException {
        IOUtils.closeStream(this.checksumIn);
        this.checksumIn = null;
    }

    public void dropCacheBehindReads(String identifier, long offset, long len, int flags) throws NativeIOException {
        assert (this.dataInFd != null) : "null dataInFd!";
        this.fileIoProvider.posixFadvise(this.getVolumeRef().getVolume(), identifier, this.dataInFd, offset, len, flags);
    }

    public void closeStreams() throws IOException {
        IOException ioe = null;
        if (this.checksumIn != null) {
            try {
                this.checksumIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.checksumIn = null;
        }
        if (this.dataIn != null) {
            try {
                this.dataIn.close();
            }
            catch (IOException e) {
                ioe = e;
            }
            this.dataIn = null;
            this.dataInFd = null;
        }
        if (this.volumeRef != null) {
            IOUtils.cleanupWithLogger(null, this.volumeRef);
            this.volumeRef = null;
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void close() {
        IOUtils.closeStream(this.dataIn);
        this.dataIn = null;
        this.dataInFd = null;
        IOUtils.closeStream(this.checksumIn);
        this.checksumIn = null;
        IOUtils.cleanupWithLogger(null, this.volumeRef);
        this.volumeRef = null;
    }
}

