/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemVolumeManager;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PmemMappedBlock
implements MappableBlock {
    private static final Logger LOG = LoggerFactory.getLogger(PmemMappedBlock.class);
    private long length;
    private ExtendedBlockId key;

    PmemMappedBlock(long length, ExtendedBlockId key) {
        assert (length > 0L);
        this.length = length;
        this.key = key;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddress() {
        return -1L;
    }

    @Override
    public ExtendedBlockId getKey() {
        return this.key;
    }

    @Override
    public void close() {
        String cacheFilePath = null;
        try {
            cacheFilePath = PmemVolumeManager.getInstance().getCachePath(this.key);
            FsDatasetUtil.deleteMappedFile(cacheFilePath);
            LOG.info("Successfully uncached one replica:{} from persistent memory, [cached path={}, length={}]", this.key, cacheFilePath, this.length);
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the mapped File: {}!", (Object)cacheFilePath, (Object)e);
        }
    }
}

