/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.commons.lang3.StringUtils;

public class AccumuloSecurityException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String user;
    private String tableInfo;
    private SecurityErrorCode errorCode;

    private static String getDefaultErrorMessage(SecurityErrorCode errorcode) {
        switch (errorcode == null ? SecurityErrorCode.DEFAULT_SECURITY_ERROR : errorcode) {
            case BAD_CREDENTIALS: {
                return "Username or Password is Invalid";
            }
            case CONNECTION_ERROR: {
                return "Connection Error Occurred";
            }
            case PERMISSION_DENIED: {
                return "User does not have permission to perform this action";
            }
            case USER_DOESNT_EXIST: {
                return "The user does not exist";
            }
            case USER_EXISTS: {
                return "The user exists";
            }
            case GRANT_INVALID: {
                return "The GRANT permission cannot be granted or revoked";
            }
            case BAD_AUTHORIZATIONS: {
                return "The user does not have the specified authorizations assigned";
            }
            case UNSUPPORTED_OPERATION: {
                return "The configured security handler does not support this operation";
            }
            case INVALID_TOKEN: {
                return "The configured authenticator does not accept this type of token";
            }
            case AUTHENTICATOR_FAILED: {
                return "The configured authenticator failed for some reason";
            }
            case AUTHORIZOR_FAILED: {
                return "The configured authorizor failed for some reason";
            }
            case PERMISSIONHANDLER_FAILED: {
                return "The configured permission handler failed for some reason";
            }
            case TOKEN_EXPIRED: {
                return "The supplied token expired, please update and try again";
            }
            case INSUFFICIENT_PROPERTIES: {
                return "The login properties supplied are not sufficient for authentication. Please check the requested properties and try again";
            }
        }
        return "Unknown security exception";
    }

    public ThriftSecurityException asThriftException() {
        return new ThriftSecurityException(this.user, this.errorCode);
    }

    public AccumuloSecurityException(ThriftSecurityException thrift) {
        this(thrift.getUser(), thrift.getCode(), (Throwable)((Object)thrift));
    }

    public AccumuloSecurityException(String user, SecurityErrorCode errorcode, Throwable cause) {
        super(AccumuloSecurityException.getDefaultErrorMessage(errorcode), cause);
        this.user = user;
        this.errorCode = errorcode == null ? SecurityErrorCode.DEFAULT_SECURITY_ERROR : errorcode;
    }

    public AccumuloSecurityException(String user, SecurityErrorCode errorcode, String tableInfo, Throwable cause) {
        super(AccumuloSecurityException.getDefaultErrorMessage(errorcode), cause);
        this.user = user;
        this.errorCode = errorcode == null ? SecurityErrorCode.DEFAULT_SECURITY_ERROR : errorcode;
        this.tableInfo = tableInfo;
    }

    public AccumuloSecurityException(String user, SecurityErrorCode errorcode) {
        super(AccumuloSecurityException.getDefaultErrorMessage(errorcode));
        this.user = user;
        this.errorCode = errorcode == null ? SecurityErrorCode.DEFAULT_SECURITY_ERROR : errorcode;
    }

    public AccumuloSecurityException(String user, SecurityErrorCode errorcode, String tableInfo) {
        super(AccumuloSecurityException.getDefaultErrorMessage(errorcode));
        this.user = user;
        this.errorCode = errorcode == null ? SecurityErrorCode.DEFAULT_SECURITY_ERROR : errorcode;
        this.tableInfo = tableInfo;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String s) {
        this.user = s;
    }

    public String getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(String tableInfo) {
        this.tableInfo = tableInfo;
    }

    public org.apache.accumulo.core.client.security.SecurityErrorCode getSecurityErrorCode() {
        return org.apache.accumulo.core.client.security.SecurityErrorCode.valueOf(this.errorCode.name());
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Error ").append((Object)this.errorCode);
        message.append(" for user ").append(this.user);
        if (!StringUtils.isEmpty((CharSequence)this.tableInfo)) {
            message.append(" on table ").append(this.tableInfo);
        }
        message.append(" - ").append(super.getMessage());
        return message.toString();
    }
}

