/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.util.Map;
import java.util.Objects;

public class PluginConfig {
    private final String className;
    private final Map<String, String> options;

    public PluginConfig(String className) {
        this.className = Objects.requireNonNull(className);
        this.options = Map.of();
    }

    public PluginConfig(String className, Map<String, String> options) {
        this.className = Objects.requireNonNull(className);
        this.options = Map.copyOf(options);
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public int hashCode() {
        return this.className.hashCode() + this.options.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PluginConfig) {
            PluginConfig ocsc = (PluginConfig)o;
            return this.className.equals(ocsc.className) && this.options.equals(ocsc.options);
        }
        return false;
    }

    public String toString() {
        return "[className=" + this.className + ", options=" + this.options + "]";
    }
}

