/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.summary.Summarizer;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.commons.lang3.mutable.MutableLong;

public abstract class CountingSummarizer<K>
implements Summarizer {
    public static final String MAX_COUNTERS_OPT = "maxCounters";
    public static final String MAX_COUNTER_LEN_OPT = "maxCounterLen";
    public static final String INGNORE_DELETES_OPT = "ignoreDeletes";
    public static final String COUNTER_STAT_PREFIX = "c:";
    public static final String TOO_MANY_STAT = "tooMany";
    public static final String TOO_LONG_STAT = "tooLong";
    public static final String EMITTED_STAT = "emitted";
    public static final String DELETES_IGNORED_STAT = "deletesIgnored";
    public static final String SEEN_STAT = "seen";
    public static final String MAX_COUNTER_DEFAULT = "1024";
    public static final String MAX_CKL_DEFAULT = "128";
    public static final String INGNORE_DELETES_DEFAULT = "true";
    private static final String[] ALL_STATS = new String[]{"tooLong", "tooMany", "emitted", "seen", "deletesIgnored"};
    private int maxCounters;
    private int maxCounterKeyLen;
    private boolean ignoreDeletes;

    private void init(SummarizerConfiguration conf) {
        this.maxCounters = Integer.parseInt(conf.getOptions().getOrDefault(MAX_COUNTERS_OPT, MAX_COUNTER_DEFAULT));
        this.maxCounterKeyLen = Integer.parseInt(conf.getOptions().getOrDefault(MAX_COUNTER_LEN_OPT, MAX_CKL_DEFAULT));
        this.ignoreDeletes = Boolean.parseBoolean(conf.getOptions().getOrDefault(INGNORE_DELETES_OPT, INGNORE_DELETES_DEFAULT));
    }

    protected abstract Converter<K> converter();

    protected Function<K, String> encoder() {
        return Object::toString;
    }

    protected UnaryOperator<K> copier() {
        return UnaryOperator.identity();
    }

    @Override
    public Summarizer.Collector collector(SummarizerConfiguration sc) {
        this.init(sc);
        return new Summarizer.Collector(){
            private Map<K, MutableLong> counters = new HashMap();
            private long tooMany = 0L;
            private long tooLong = 0L;
            private long seen = 0L;
            private long emitted = 0L;
            private long deleted = 0L;
            private Converter<K> converter = CountingSummarizer.this.converter();
            private Function<K, String> encoder = CountingSummarizer.this.encoder();
            private UnaryOperator<K> copier = CountingSummarizer.this.copier();

            private void incrementCounter(K counter) {
                ++this.emitted;
                MutableLong ml = this.counters.get(counter);
                if (ml == null) {
                    if (this.counters.size() >= CountingSummarizer.this.maxCounters) {
                        ++this.tooMany;
                    } else if (this.encoder.apply(counter).length() >= CountingSummarizer.this.maxCounterKeyLen) {
                        ++this.tooLong;
                    } else {
                        this.counters.put(this.copier.apply(counter), new MutableLong(1L));
                    }
                } else {
                    ml.increment();
                }
            }

            @Override
            public void accept(Key k, Value v) {
                ++this.seen;
                if (CountingSummarizer.this.ignoreDeletes && k.isDeleted()) {
                    ++this.deleted;
                } else {
                    this.converter.convert(k, v, this::incrementCounter);
                }
            }

            @Override
            public void summarize(Summarizer.StatisticConsumer sc) {
                StringBuilder sb = new StringBuilder(CountingSummarizer.COUNTER_STAT_PREFIX);
                for (Map.Entry entry : this.counters.entrySet()) {
                    sb.setLength(CountingSummarizer.COUNTER_STAT_PREFIX.length());
                    sb.append(this.encoder.apply(entry.getKey()));
                    sc.accept(sb.toString(), entry.getValue().longValue());
                }
                sc.accept(CountingSummarizer.TOO_MANY_STAT, this.tooMany);
                sc.accept(CountingSummarizer.TOO_LONG_STAT, this.tooLong);
                sc.accept(CountingSummarizer.EMITTED_STAT, this.emitted);
                sc.accept(CountingSummarizer.SEEN_STAT, this.seen);
                sc.accept(CountingSummarizer.DELETES_IGNORED_STAT, this.deleted);
            }
        };
    }

    @Override
    public Summarizer.Combiner combiner(SummarizerConfiguration sc) {
        this.init(sc);
        return (summary1, summary2) -> {
            for (String key : ALL_STATS) {
                summary1.merge(key, summary2.getOrDefault(key, 0L), Long::sum);
            }
            for (Map.Entry entry : summary2.entrySet()) {
                String k2 = (String)entry.getKey();
                Long v2 = (Long)entry.getValue();
                if (!k2.startsWith(COUNTER_STAT_PREFIX)) continue;
                summary1.merge(k2, v2, Long::sum);
            }
            if (summary1.size() - ALL_STATS.length > this.maxCounters) {
                List keysToRemove = summary1.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(COUNTER_STAT_PREFIX)).sorted((e1, e2) -> Long.compare((Long)e2.getValue(), (Long)e1.getValue())).skip(this.maxCounters).map(Map.Entry::getKey).collect(Collectors.toList());
                long l = 0L;
                for (String key : keysToRemove) {
                    l += ((Long)summary1.remove(key)).longValue();
                }
                summary1.merge(TOO_MANY_STAT, l, Long::sum);
            }
        };
    }

    public static interface Converter<K> {
        public void convert(Key var1, Value var2, Consumer<K> var3);
    }
}

