/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Condition;
import org.apache.accumulo.core.data.Mutation;
import org.apache.hadoop.io.Text;

public class ConditionalMutation
extends Mutation {
    private List<Condition> conditions = new ArrayList<Condition>();

    public ConditionalMutation(byte[] row, Condition ... conditions) {
        super(row);
        this.init(conditions);
    }

    public ConditionalMutation(byte[] row, int start, int length, Condition ... conditions) {
        super(row, start, length);
        this.init(conditions);
    }

    public ConditionalMutation(Text row, Condition ... conditions) {
        super(row);
        this.init(conditions);
    }

    public ConditionalMutation(CharSequence row, Condition ... conditions) {
        super(row);
        this.init(conditions);
    }

    public ConditionalMutation(ByteSequence row, Condition ... conditions) {
        super(row.toArray());
        this.init(conditions);
    }

    public ConditionalMutation(ConditionalMutation cm) {
        super(cm);
        this.conditions = new ArrayList<Condition>(cm.conditions);
    }

    private void init(Condition ... conditions) {
        Preconditions.checkArgument((conditions != null ? 1 : 0) != 0, (Object)"conditions is null");
        this.conditions.addAll(Arrays.asList(conditions));
    }

    public void addCondition(Condition condition) {
        Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"condition is null");
        this.conditions.add(condition);
    }

    public List<Condition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ConditionalMutation)) {
            return false;
        }
        ConditionalMutation cm = (ConditionalMutation)o;
        if (!this.conditions.equals(cm.conditions)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + this.conditions.hashCode();
        return result;
    }
}

