/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.IOException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.file.BloomFilterLayer;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.summary.SummaryWriter;

class DispatchingFileFactory
extends FileOperations {
    DispatchingFileFactory() {
    }

    private FileOperations findFileFactory(FileOperations.FileOptions options) {
        TabletFile file = options.getFile();
        String name = file.getPath().getName();
        String[] sp = name.split("\\.");
        if (sp.length < 2) {
            throw new IllegalArgumentException("File name " + name + " has no extension");
        }
        String extension = sp[sp.length - 1];
        if (extension.equals("rf") || extension.equals("rf_tmp")) {
            return new RFileOperations();
        }
        throw new IllegalArgumentException("File type " + extension + " not supported");
    }

    @Override
    protected long getFileSize(FileOperations.FileOptions options) throws IOException {
        return this.findFileFactory(options).getFileSize(options);
    }

    @Override
    protected FileSKVWriter openWriter(FileOperations.FileOptions options) throws IOException {
        RFileOperations fileOps = new RFileOperations();
        FileSKVWriter writer = ((FileOperations)fileOps).openWriter(options);
        if (options.getTableConfiguration().getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            writer = new BloomFilterLayer.Writer(writer, options.getTableConfiguration(), options.isAccumuloStartEnabled());
        }
        return SummaryWriter.wrap(writer, options.getTableConfiguration(), options.isAccumuloStartEnabled());
    }

    @Override
    protected FileSKVIterator openIndex(FileOperations.FileOptions options) throws IOException {
        return this.findFileFactory(options).openIndex(options);
    }

    @Override
    protected FileSKVIterator openReader(FileOperations.FileOptions options) throws IOException {
        FileSKVIterator iter = this.findFileFactory(options).openReader(options);
        if (options.getTableConfiguration().getBoolean(Property.TABLE_BLOOM_ENABLED)) {
            return new BloomFilterLayer.Reader(iter, options.getTableConfiguration());
        }
        return iter;
    }

    @Override
    protected FileSKVIterator openScanReader(FileOperations.FileOptions options) throws IOException {
        return this.findFileFactory(options).openScanReader(options);
    }
}

