/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.impl;

import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockCacheManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BlockCacheManager.class);

    public static synchronized BlockCacheManager getInstance(AccumuloConfiguration conf) throws ReflectiveOperationException {
        String impl = conf.get(Property.TSERV_CACHE_MANAGER_IMPL);
        Class<BlockCacheManager> clazz = ClassLoaderUtil.loadClass(impl, BlockCacheManager.class);
        LOG.info("Created new block cache manager of type: {}", (Object)clazz.getSimpleName());
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static synchronized BlockCacheManager getClientInstance(AccumuloConfiguration conf) throws ReflectiveOperationException {
        String impl = conf.get(Property.TSERV_CACHE_MANAGER_IMPL);
        Class<BlockCacheManager> clazz = Class.forName(impl).asSubclass(BlockCacheManager.class);
        LOG.info("Created new block cache factory of type: {}", (Object)clazz.getSimpleName());
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

