/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

public class Pair<A, B> {
    private final A first;
    private final B second;

    public Pair(A f, B s) {
        this.first = f;
        this.second = s;
    }

    public int hashCode() {
        return Objects.hashCode(this.first) + Objects.hashCode(this.second);
    }

    public boolean equals(Object o) {
        if (o instanceof Pair) {
            Pair other = (Pair)o;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }
        return false;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return this.toString("(", ",", ")");
    }

    public String toString(String prefix, String separator, String suffix) {
        return prefix + this.first + separator + this.second + suffix;
    }

    public Map.Entry<A, B> toMapEntry() {
        return new AbstractMap.SimpleImmutableEntry<A, B>(this.getFirst(), this.getSecond());
    }

    public Pair<B, A> swap() {
        return new Pair<B, A>(this.getSecond(), this.getFirst());
    }

    public static <K2, V2, K1 extends K2, V1 extends V2> Pair<K2, V2> fromEntry(Map.Entry<K1, V1> entry) {
        return new Pair<K1, V1>(entry.getKey(), entry.getValue());
    }
}

