/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.clientImpl.bulk.Bulk;
import org.apache.accumulo.core.clientImpl.bulk.LoadMappingIterator;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.json.ByteArrayToBase64TypeAdapter;
import org.apache.hadoop.fs.Path;

public class BulkSerialize {
    private static final Gson gson = ByteArrayToBase64TypeAdapter.createBase64Gson();

    public static void writeLoadMapping(SortedMap<KeyExtent, Bulk.Files> loadMapping, String sourceDir, Output output) throws IOException {
        Path lmFile = new Path(sourceDir, "loadmap.json");
        try (OutputStream fsOut = output.create(lmFile);
             JsonWriter writer = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(fsOut, StandardCharsets.UTF_8)));){
            writer.setIndent("  ");
            writer.beginArray();
            Set<Map.Entry<KeyExtent, Bulk.Files>> es = loadMapping.entrySet();
            for (Map.Entry<KeyExtent, Bulk.Files> entry : es) {
                Bulk.Mapping mapping = new Bulk.Mapping(entry.getKey(), entry.getValue());
                gson.toJson((Object)mapping, Bulk.Mapping.class, writer);
            }
            writer.endArray();
        }
    }

    public static LoadMappingIterator readLoadMapping(String bulkDir, TableId tableId, Input input) throws IOException {
        Path lmFile = new Path(bulkDir, "loadmap.json");
        return new LoadMappingIterator(tableId, input.open(lmFile));
    }

    public static void writeRenameMap(Map<String, String> oldToNewNameMap, String bulkDir, Output output) throws IOException {
        Path renamingFile = new Path(bulkDir, "renames.json");
        try (OutputStream fsOut = output.create(renamingFile);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fsOut));){
            LazySingletons.GSON.get().toJson(oldToNewNameMap, (Appendable)writer);
        }
    }

    public static Map<String, String> readRenameMap(String bulkDir, Input input) throws IOException {
        Map oldToNewNameMap;
        Path renamingFile = new Path(bulkDir, "renames.json");
        try (InputStream fis = input.open(renamingFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
            oldToNewNameMap = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
        }
        return oldToNewNameMap;
    }

    public static LoadMappingIterator getUpdatedLoadMapping(String bulkDir, TableId tableId, Input input) throws IOException {
        Map<String, String> renames = BulkSerialize.readRenameMap(bulkDir, input);
        LoadMappingIterator lmi = BulkSerialize.readLoadMapping(bulkDir, tableId, input);
        lmi.setRenameMap(renames);
        return lmi;
    }

    public static interface Input {
        public InputStream open(Path var1) throws IOException;
    }

    public static interface Output {
        public OutputStream create(Path var1) throws IOException;
    }
}

