/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.accumulo.AccumuloErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.hadoop.io.Text;

public class AccumuloTableManager {
    private static final Logger LOG = Logger.get(AccumuloTableManager.class);
    private final AccumuloClient client;

    @Inject
    public AccumuloTableManager(AccumuloClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public void createNamespace(String schema) {
        try {
            this.client.namespaceOperations().create(schema);
        }
        catch (NamespaceExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Namespace already exists: " + schema, (Throwable)e);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to create Accumulo namespace: " + schema, e);
        }
    }

    public void dropNamespace(String schema) {
        try {
            this.client.namespaceOperations().delete(schema);
        }
        catch (AccumuloException | AccumuloSecurityException | NamespaceNotEmptyException | NamespaceNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to delete Accumulo namespace: " + schema, e);
        }
    }

    public boolean namespaceExists(String schema) {
        try {
            return this.client.namespaceOperations().exists(schema);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to check for existence Accumulo namespace: " + schema, e);
        }
    }

    public boolean exists(String table) {
        return this.client.tableOperations().exists(table);
    }

    public void createAccumuloTable(String table) {
        try {
            this.client.tableOperations().create(table);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to create Accumulo table", e);
        }
        catch (TableExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_EXISTS, "Accumulo table already exists", (Throwable)e);
        }
    }

    public void setLocalityGroups(String tableName, Map<String, Set<Text>> groups) {
        if (groups.isEmpty()) {
            return;
        }
        try {
            this.client.tableOperations().setLocalityGroups(tableName, groups);
            LOG.debug("Set locality groups for %s to %s", new Object[]{tableName, groups});
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to set locality groups", e);
        }
        catch (TableNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to set locality groups, table does not exist", (Throwable)e);
        }
    }

    public void setIterator(String table, IteratorSetting setting) {
        try {
            Map iterators = this.client.tableOperations().listIterators(table);
            if (iterators.containsKey(setting.getName())) {
                this.client.tableOperations().removeIterator(table, setting.getName(), (EnumSet)iterators.get(setting.getName()));
            }
            this.client.tableOperations().attachIterator(table, setting);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to set iterator on table " + table, e);
        }
        catch (TableNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to set iterator, table does not exist", (Throwable)e);
        }
    }

    public void deleteAccumuloTable(String tableName) {
        try {
            this.client.tableOperations().delete(tableName);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to delete Accumulo table", e);
        }
        catch (TableNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to delete Accumulo table, does not exist", (Throwable)e);
        }
    }

    public void renameAccumuloTable(String oldName, String newName) {
        try {
            this.client.tableOperations().rename(oldName, newName);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Failed to rename table", e);
        }
        catch (TableNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Failed to rename table, old table does not exist", (Throwable)e);
        }
        catch (TableExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_EXISTS, "Failed to rename table, new table already exists", (Throwable)e);
        }
    }
}

