/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.io;

import com.google.inject.Inject;
import io.trino.plugin.accumulo.AccumuloMetadataManager;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.io.AccumuloPageSink;
import io.trino.plugin.accumulo.model.AccumuloTableHandle;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloClient;

public class AccumuloPageSinkProvider
implements ConnectorPageSinkProvider {
    private final AccumuloMetadataManager metadataManager;
    private final AccumuloClient client;
    private final String username;

    @Inject
    public AccumuloPageSinkProvider(AccumuloClient client, AccumuloConfig config, AccumuloMetadataManager metadataManager) {
        this.metadataManager = Objects.requireNonNull(metadataManager, "metadataManager is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.username = config.getUsername();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        AccumuloTableHandle tableHandle = (AccumuloTableHandle)outputTableHandle;
        return new AccumuloPageSink(this.client, this.metadataManager.getTable(tableHandle.toSchemaTableName()), this.username);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        return this.createPageSink(transactionHandle, session, (ConnectorOutputTableHandle)insertTableHandle, pageSinkId);
    }
}

