/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.io;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.accumulo.conf.AccumuloConfig;
import io.trino.plugin.accumulo.io.AccumuloRecordSet;
import io.trino.plugin.accumulo.model.AccumuloColumnHandle;
import io.trino.plugin.accumulo.model.AccumuloSplit;
import io.trino.plugin.accumulo.model.AccumuloTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloClient;

public class AccumuloRecordSetProvider
implements ConnectorRecordSetProvider {
    private final AccumuloClient client;
    private final String username;

    @Inject
    public AccumuloRecordSetProvider(AccumuloClient client, AccumuloConfig config) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.username = config.getUsername();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        AccumuloSplit accSplit = (AccumuloSplit)split;
        AccumuloTableHandle accTable = (AccumuloTableHandle)table;
        List accColumns = (List)columns.stream().map(AccumuloColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new AccumuloRecordSet(this.client, session, accSplit, this.username, accTable, accColumns);
    }
}

