/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.org.apache.kerby.asn1.util;

import io.trino.hadoop.$internal.org.apache.kerby.asn1.Tag;
import java.nio.ByteBuffer;

public final class Asn1Util {
    private Asn1Util() {
    }

    public static int lengthOfBodyLength(int bodyLength) {
        int length = 1;
        if (bodyLength > 127) {
            int payload = bodyLength;
            while (payload != 0) {
                payload >>= 8;
                ++length;
            }
        }
        return length;
    }

    public static int lengthOfTagLength(int tagNo) {
        int length = 1;
        if (tagNo >= 31) {
            if (tagNo < 128) {
                ++length;
            } else {
                ++length;
                do {
                    ++length;
                } while ((tagNo >>= 7) > 127);
            }
        }
        return length;
    }

    public static void encodeTag(ByteBuffer buffer, Tag tag) {
        int flags = tag.tagFlags();
        int tagNo = tag.tagNo();
        if (tagNo < 31) {
            buffer.put((byte)(flags | tagNo));
        } else {
            buffer.put((byte)(flags | 0x1F));
            if (tagNo < 128) {
                buffer.put((byte)tagNo);
            } else {
                byte[] tmpBytes = new byte[5];
                int iPut = tmpBytes.length;
                tmpBytes[--iPut] = (byte)(tagNo & 0x7F);
                do {
                    tmpBytes[--iPut] = (byte)((tagNo >>= 7) & 0x7F | 0x80);
                } while (tagNo > 127);
                buffer.put(tmpBytes, iPut, tmpBytes.length - iPut);
            }
        }
    }

    public static void encodeLength(ByteBuffer buffer, int bodyLength) {
        if (bodyLength < 128) {
            buffer.put((byte)bodyLength);
        } else {
            int length = 0;
            int payload = bodyLength;
            while (payload != 0) {
                payload >>= 8;
                ++length;
            }
            buffer.put((byte)(length | 0x80));
            payload = bodyLength;
            for (int i = length - 1; i >= 0; --i) {
                buffer.put((byte)(payload >> i * 8));
            }
        }
    }

    public static byte[] readAllLeftBytes(ByteBuffer buffer) {
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }
}

